package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.BackLog;
import com.xforceplus.ultraman.app.imagesaas.service.IBackLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-03-01
 */
@RestController
public class BackLogController {

  @Autowired
  private IBackLogService backLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param backLog ${table.comment}
   * @return
   */
  @GetMapping("/backlogs" )
  public XfR getBackLogs(XfPage page, BackLog backLog) {
    return XfR.ok(backLogServiceImpl.page(page, Wrappers.query(backLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/backlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(backLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param backLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/backlogs")
  public XfR save(@RequestBody BackLog backLog) {
     return XfR.ok(backLogServiceImpl.save(backLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param backLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/backlogs/{id}")
  public XfR putUpdate(@RequestBody BackLog backLog,@PathVariable Long id) {
      backLog.setId(id);
      return XfR.ok(backLogServiceImpl.updateById(backLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param backLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/backlogs/{id}")
  public XfR patchUpdate(@RequestBody BackLog backLog,@PathVariable Long id) {
      BackLog upbackLog = backLogServiceImpl.getById(id);
      if(upbackLog != null){
        upbackLog = ObjectCopyUtils.copyProperties(backLog,upbackLog,true);
      }
      return XfR.ok(backLogServiceImpl.updateById(upbackLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/backlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(backLogServiceImpl.removeById(id));
  }

  @PostMapping("/backlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "back_log");
     params.put("request", condition);

     return XfR.ok(backLogServiceImpl.querys(params));
  }

}
