package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketOther;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketOtherService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的其他发票前端控制器
 *
 * @author ultraman
 * @date 2022-03-01
 */
@RestController
public class CompareTicketOtherController {

  @Autowired
  private ICompareTicketOtherService compareTicketOtherServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketOther 数据比对用途的其他发票
   * @return
   */
  @GetMapping("/compareticketothers" )
  public XfR getCompareTicketOthers(XfPage page, CompareTicketOther compareTicketOther) {
    return XfR.ok(compareTicketOtherServiceImpl.page(page, Wrappers.query(compareTicketOther)));
  }

  /**
   * 通过id查询数据比对用途的其他发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketothers/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketOtherServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的其他发票
   * @param compareTicketOther 数据比对用途的其他发票
   * @return XfR
   */
  @PostMapping("/compareticketothers")
  public XfR save(@RequestBody CompareTicketOther compareTicketOther) {
     return XfR.ok(compareTicketOtherServiceImpl.save(compareTicketOther));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的其他发票
   * @param compareTicketOther 数据比对用途的其他发票
   * @return XfR
   */
  @PutMapping("/compareticketothers/{id}")
  public XfR putUpdate(@RequestBody CompareTicketOther compareTicketOther,@PathVariable Long id) {
      compareTicketOther.setId(id);
      return XfR.ok(compareTicketOtherServiceImpl.updateById(compareTicketOther));
  }

  /**
   * 修改-传入修改的数据数据比对用途的其他发票
   * @param compareTicketOther 数据比对用途的其他发票
   * @return XfR
   */
  @PatchMapping("/compareticketothers/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketOther compareTicketOther,@PathVariable Long id) {
      CompareTicketOther upcompareTicketOther = compareTicketOtherServiceImpl.getById(id);
      if(upcompareTicketOther != null){
        upcompareTicketOther = ObjectCopyUtils.copyProperties(compareTicketOther,upcompareTicketOther,true);
      }
      return XfR.ok(compareTicketOtherServiceImpl.updateById(upcompareTicketOther));
  }

  /**
   * 通过id删除数据比对用途的其他发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketothers/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketOtherServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketothers/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_other");
     params.put("request", condition);

     return XfR.ok(compareTicketOtherServiceImpl.querys(params));
  }

}
