package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ExpensesBill;
import com.xforceplus.ultraman.app.imagesaas.service.IExpensesBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 费用报销单前端控制器
 *
 * @author ultraman
 * @date 2022-03-01
 */
@RestController
public class ExpensesBillController {

  @Autowired
  private IExpensesBillService expensesBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param expensesBill 费用报销单
   * @return
   */
  @GetMapping("/expensesbills" )
  public XfR getExpensesBills(XfPage page, ExpensesBill expensesBill) {
    return XfR.ok(expensesBillServiceImpl.page(page, Wrappers.query(expensesBill)));
  }

  /**
   * 通过id查询费用报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/expensesbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(expensesBillServiceImpl.getById(id));
  }

  /**
   * 新增费用报销单
   * @param expensesBill 费用报销单
   * @return XfR
   */
  @PostMapping("/expensesbills")
  public XfR save(@RequestBody ExpensesBill expensesBill) {
     return XfR.ok(expensesBillServiceImpl.save(expensesBill));
  }

  /**
   * 修改-传入修改后的全部数据费用报销单
   * @param expensesBill 费用报销单
   * @return XfR
   */
  @PutMapping("/expensesbills/{id}")
  public XfR putUpdate(@RequestBody ExpensesBill expensesBill,@PathVariable Long id) {
      expensesBill.setId(id);
      return XfR.ok(expensesBillServiceImpl.updateById(expensesBill));
  }

  /**
   * 修改-传入修改的数据费用报销单
   * @param expensesBill 费用报销单
   * @return XfR
   */
  @PatchMapping("/expensesbills/{id}")
  public XfR patchUpdate(@RequestBody ExpensesBill expensesBill,@PathVariable Long id) {
      ExpensesBill upexpensesBill = expensesBillServiceImpl.getById(id);
      if(upexpensesBill != null){
        upexpensesBill = ObjectCopyUtils.copyProperties(expensesBill,upexpensesBill,true);
      }
      return XfR.ok(expensesBillServiceImpl.updateById(upexpensesBill));
  }

  /**
   * 通过id删除费用报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/expensesbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(expensesBillServiceImpl.removeById(id));
  }

  @PostMapping("/expensesbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "expenses_bill");
     params.put("request", condition);

     return XfR.ok(expensesBillServiceImpl.querys(params));
  }

}
