package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketTaxi;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketTaxiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-03-01
 */
@RestController
public class TicketTaxiController {

  @Autowired
  private ITicketTaxiService ticketTaxiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketTaxi ${table.comment}
   * @return
   */
  @GetMapping("/tickettaxis" )
  public XfR getTicketTaxis(XfPage page, TicketTaxi ticketTaxi) {
    return XfR.ok(ticketTaxiServiceImpl.page(page, Wrappers.query(ticketTaxi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tickettaxis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketTaxiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketTaxi ${table.comment}
   * @return XfR
   */
  @PostMapping("/tickettaxis")
  public XfR save(@RequestBody TicketTaxi ticketTaxi) {
     return XfR.ok(ticketTaxiServiceImpl.save(ticketTaxi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketTaxi ${table.comment}
   * @return XfR
   */
  @PutMapping("/tickettaxis/{id}")
  public XfR putUpdate(@RequestBody TicketTaxi ticketTaxi,@PathVariable Long id) {
      ticketTaxi.setId(id);
      return XfR.ok(ticketTaxiServiceImpl.updateById(ticketTaxi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketTaxi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tickettaxis/{id}")
  public XfR patchUpdate(@RequestBody TicketTaxi ticketTaxi,@PathVariable Long id) {
      TicketTaxi upticketTaxi = ticketTaxiServiceImpl.getById(id);
      if(upticketTaxi != null){
        upticketTaxi = ObjectCopyUtils.copyProperties(ticketTaxi,upticketTaxi,true);
      }
      return XfR.ok(ticketTaxiServiceImpl.updateById(upticketTaxi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tickettaxis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketTaxiServiceImpl.removeById(id));
  }

  @PostMapping("/tickettaxis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_taxi");
     params.put("request", condition);

     return XfR.ok(ticketTaxiServiceImpl.querys(params));
  }

}
