package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.AccountBill;
import com.xforceplus.ultraman.app.imagesaas.service.IAccountBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 记账工单前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class AccountBillController {

  @Autowired
  private IAccountBillService accountBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param accountBill 记账工单
   * @return
   */
  @GetMapping("/accountbills" )
  public XfR getAccountBills(XfPage page, AccountBill accountBill) {
    return XfR.ok(accountBillServiceImpl.page(page, Wrappers.query(accountBill)));
  }

  /**
   * 通过id查询记账工单
   * @param  id
   * @return XfR
   */
  @GetMapping("/accountbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(accountBillServiceImpl.getById(id));
  }

  /**
   * 新增记账工单
   * @param accountBill 记账工单
   * @return XfR
   */
  @PostMapping("/accountbills")
  public XfR save(@RequestBody AccountBill accountBill) {
     return XfR.ok(accountBillServiceImpl.save(accountBill));
  }

  /**
   * 修改-传入修改后的全部数据记账工单
   * @param accountBill 记账工单
   * @return XfR
   */
  @PutMapping("/accountbills/{id}")
  public XfR putUpdate(@RequestBody AccountBill accountBill,@PathVariable Long id) {
      accountBill.setId(id);
      return XfR.ok(accountBillServiceImpl.updateById(accountBill));
  }

  /**
   * 修改-传入修改的数据记账工单
   * @param accountBill 记账工单
   * @return XfR
   */
  @PatchMapping("/accountbills/{id}")
  public XfR patchUpdate(@RequestBody AccountBill accountBill,@PathVariable Long id) {
      AccountBill upaccountBill = accountBillServiceImpl.getById(id);
      if(upaccountBill != null){
        upaccountBill = ObjectCopyUtils.copyProperties(accountBill,upaccountBill,true);
      }
      return XfR.ok(accountBillServiceImpl.updateById(upaccountBill));
  }

  /**
   * 通过id删除记账工单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/accountbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(accountBillServiceImpl.removeById(id));
  }

  @PostMapping("/accountbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "account_bill");
     params.put("request", condition);

     return XfR.ok(accountBillServiceImpl.querys(params));
  }

}
