package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.BusinessLog;
import com.xforceplus.ultraman.app.imagesaas.service.IBusinessLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 业务日志前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class BusinessLogController {

  @Autowired
  private IBusinessLogService businessLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param businessLog 业务日志
   * @return
   */
  @GetMapping("/businesslogs" )
  public XfR getBusinessLogs(XfPage page, BusinessLog businessLog) {
    return XfR.ok(businessLogServiceImpl.page(page, Wrappers.query(businessLog)));
  }

  /**
   * 通过id查询业务日志
   * @param  id
   * @return XfR
   */
  @GetMapping("/businesslogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(businessLogServiceImpl.getById(id));
  }

  /**
   * 新增业务日志
   * @param businessLog 业务日志
   * @return XfR
   */
  @PostMapping("/businesslogs")
  public XfR save(@RequestBody BusinessLog businessLog) {
     return XfR.ok(businessLogServiceImpl.save(businessLog));
  }

  /**
   * 修改-传入修改后的全部数据业务日志
   * @param businessLog 业务日志
   * @return XfR
   */
  @PutMapping("/businesslogs/{id}")
  public XfR putUpdate(@RequestBody BusinessLog businessLog,@PathVariable Long id) {
      businessLog.setId(id);
      return XfR.ok(businessLogServiceImpl.updateById(businessLog));
  }

  /**
   * 修改-传入修改的数据业务日志
   * @param businessLog 业务日志
   * @return XfR
   */
  @PatchMapping("/businesslogs/{id}")
  public XfR patchUpdate(@RequestBody BusinessLog businessLog,@PathVariable Long id) {
      BusinessLog upbusinessLog = businessLogServiceImpl.getById(id);
      if(upbusinessLog != null){
        upbusinessLog = ObjectCopyUtils.copyProperties(businessLog,upbusinessLog,true);
      }
      return XfR.ok(businessLogServiceImpl.updateById(upbusinessLog));
  }

  /**
   * 通过id删除业务日志
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/businesslogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(businessLogServiceImpl.removeById(id));
  }

  @PostMapping("/businesslogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "business_log");
     params.put("request", condition);

     return XfR.ok(businessLogServiceImpl.querys(params));
  }

}
