package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketTrain;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的火车票前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class CompareTicketTrainController {

  @Autowired
  private ICompareTicketTrainService compareTicketTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketTrain 数据比对用途的火车票
   * @return
   */
  @GetMapping("/comparetickettrains" )
  public XfR getCompareTicketTrains(XfPage page, CompareTicketTrain compareTicketTrain) {
    return XfR.ok(compareTicketTrainServiceImpl.page(page, Wrappers.query(compareTicketTrain)));
  }

  /**
   * 通过id查询数据比对用途的火车票
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetickettrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketTrainServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的火车票
   * @param compareTicketTrain 数据比对用途的火车票
   * @return XfR
   */
  @PostMapping("/comparetickettrains")
  public XfR save(@RequestBody CompareTicketTrain compareTicketTrain) {
     return XfR.ok(compareTicketTrainServiceImpl.save(compareTicketTrain));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的火车票
   * @param compareTicketTrain 数据比对用途的火车票
   * @return XfR
   */
  @PutMapping("/comparetickettrains/{id}")
  public XfR putUpdate(@RequestBody CompareTicketTrain compareTicketTrain,@PathVariable Long id) {
      compareTicketTrain.setId(id);
      return XfR.ok(compareTicketTrainServiceImpl.updateById(compareTicketTrain));
  }

  /**
   * 修改-传入修改的数据数据比对用途的火车票
   * @param compareTicketTrain 数据比对用途的火车票
   * @return XfR
   */
  @PatchMapping("/comparetickettrains/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketTrain compareTicketTrain,@PathVariable Long id) {
      CompareTicketTrain upcompareTicketTrain = compareTicketTrainServiceImpl.getById(id);
      if(upcompareTicketTrain != null){
        upcompareTicketTrain = ObjectCopyUtils.copyProperties(compareTicketTrain,upcompareTicketTrain,true);
      }
      return XfR.ok(compareTicketTrainServiceImpl.updateById(upcompareTicketTrain));
  }

  /**
   * 通过id删除数据比对用途的火车票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetickettrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketTrainServiceImpl.removeById(id));
  }

  @PostMapping("/comparetickettrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_train");
     params.put("request", condition);

     return XfR.ok(compareTicketTrainServiceImpl.querys(params));
  }

}
