package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTravelExpenseBill;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTravelExpenseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的差旅报销单前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class CompareTravelExpenseBillController {

  @Autowired
  private ICompareTravelExpenseBillService compareTravelExpenseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTravelExpenseBill 数据比对用途的差旅报销单
   * @return
   */
  @GetMapping("/comparetravelexpensebills" )
  public XfR getCompareTravelExpenseBills(XfPage page, CompareTravelExpenseBill compareTravelExpenseBill) {
    return XfR.ok(compareTravelExpenseBillServiceImpl.page(page, Wrappers.query(compareTravelExpenseBill)));
  }

  /**
   * 通过id查询数据比对用途的差旅报销单
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetravelexpensebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTravelExpenseBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的差旅报销单
   * @param compareTravelExpenseBill 数据比对用途的差旅报销单
   * @return XfR
   */
  @PostMapping("/comparetravelexpensebills")
  public XfR save(@RequestBody CompareTravelExpenseBill compareTravelExpenseBill) {
     return XfR.ok(compareTravelExpenseBillServiceImpl.save(compareTravelExpenseBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的差旅报销单
   * @param compareTravelExpenseBill 数据比对用途的差旅报销单
   * @return XfR
   */
  @PutMapping("/comparetravelexpensebills/{id}")
  public XfR putUpdate(@RequestBody CompareTravelExpenseBill compareTravelExpenseBill,@PathVariable Long id) {
      compareTravelExpenseBill.setId(id);
      return XfR.ok(compareTravelExpenseBillServiceImpl.updateById(compareTravelExpenseBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的差旅报销单
   * @param compareTravelExpenseBill 数据比对用途的差旅报销单
   * @return XfR
   */
  @PatchMapping("/comparetravelexpensebills/{id}")
  public XfR patchUpdate(@RequestBody CompareTravelExpenseBill compareTravelExpenseBill,@PathVariable Long id) {
      CompareTravelExpenseBill upcompareTravelExpenseBill = compareTravelExpenseBillServiceImpl.getById(id);
      if(upcompareTravelExpenseBill != null){
        upcompareTravelExpenseBill = ObjectCopyUtils.copyProperties(compareTravelExpenseBill,upcompareTravelExpenseBill,true);
      }
      return XfR.ok(compareTravelExpenseBillServiceImpl.updateById(upcompareTravelExpenseBill));
  }

  /**
   * 通过id删除数据比对用途的差旅报销单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetravelexpensebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTravelExpenseBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparetravelexpensebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_travel_expense_bill");
     params.put("request", condition);

     return XfR.ok(compareTravelExpenseBillServiceImpl.querys(params));
  }

}
