package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.ProjectApi;
import com.xforceplus.ultraman.app.imagesaas.service.IProjectApiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class ProjectApiController {

  @Autowired
  private IProjectApiService projectApiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param projectApi ${table.comment}
   * @return
   */
  @GetMapping("/projectapis" )
  public XfR getProjectApis(XfPage page, ProjectApi projectApi) {
    return XfR.ok(projectApiServiceImpl.page(page, Wrappers.query(projectApi)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/projectapis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(projectApiServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param projectApi ${table.comment}
   * @return XfR
   */
  @PostMapping("/projectapis")
  public XfR save(@RequestBody ProjectApi projectApi) {
     return XfR.ok(projectApiServiceImpl.save(projectApi));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param projectApi ${table.comment}
   * @return XfR
   */
  @PutMapping("/projectapis/{id}")
  public XfR putUpdate(@RequestBody ProjectApi projectApi,@PathVariable Long id) {
      projectApi.setId(id);
      return XfR.ok(projectApiServiceImpl.updateById(projectApi));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param projectApi ${table.comment}
   * @return XfR
   */
  @PatchMapping("/projectapis/{id}")
  public XfR patchUpdate(@RequestBody ProjectApi projectApi,@PathVariable Long id) {
      ProjectApi upprojectApi = projectApiServiceImpl.getById(id);
      if(upprojectApi != null){
        upprojectApi = ObjectCopyUtils.copyProperties(projectApi,upprojectApi,true);
      }
      return XfR.ok(projectApiServiceImpl.updateById(upprojectApi));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/projectapis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(projectApiServiceImpl.removeById(id));
  }

  @PostMapping("/projectapis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "project_api");
     params.put("request", condition);

     return XfR.ok(projectApiServiceImpl.querys(params));
  }

}
