package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.SystemLabel;
import com.xforceplus.ultraman.app.imagesaas.service.ISystemLabelService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 系统标签前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class SystemLabelController {

  @Autowired
  private ISystemLabelService systemLabelServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemLabel 系统标签
   * @return
   */
  @GetMapping("/systemlabels" )
  public XfR getSystemLabels(XfPage page, SystemLabel systemLabel) {
    return XfR.ok(systemLabelServiceImpl.page(page, Wrappers.query(systemLabel)));
  }

  /**
   * 通过id查询系统标签
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemlabels/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemLabelServiceImpl.getById(id));
  }

  /**
   * 新增系统标签
   * @param systemLabel 系统标签
   * @return XfR
   */
  @PostMapping("/systemlabels")
  public XfR save(@RequestBody SystemLabel systemLabel) {
     return XfR.ok(systemLabelServiceImpl.save(systemLabel));
  }

  /**
   * 修改-传入修改后的全部数据系统标签
   * @param systemLabel 系统标签
   * @return XfR
   */
  @PutMapping("/systemlabels/{id}")
  public XfR putUpdate(@RequestBody SystemLabel systemLabel,@PathVariable Long id) {
      systemLabel.setId(id);
      return XfR.ok(systemLabelServiceImpl.updateById(systemLabel));
  }

  /**
   * 修改-传入修改的数据系统标签
   * @param systemLabel 系统标签
   * @return XfR
   */
  @PatchMapping("/systemlabels/{id}")
  public XfR patchUpdate(@RequestBody SystemLabel systemLabel,@PathVariable Long id) {
      SystemLabel upsystemLabel = systemLabelServiceImpl.getById(id);
      if(upsystemLabel != null){
        upsystemLabel = ObjectCopyUtils.copyProperties(systemLabel,upsystemLabel,true);
      }
      return XfR.ok(systemLabelServiceImpl.updateById(upsystemLabel));
  }

  /**
   * 通过id删除系统标签
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemlabels/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemLabelServiceImpl.removeById(id));
  }

  @PostMapping("/systemlabels/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_label");
     params.put("request", condition);

     return XfR.ok(systemLabelServiceImpl.querys(params));
  }

}
