package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketCustomsDeclaration;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketCustomsDeclarationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-04-07
 */
@RestController
public class TicketCustomsDeclarationController {

  @Autowired
  private ITicketCustomsDeclarationService ticketCustomsDeclarationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketCustomsDeclaration ${table.comment}
   * @return
   */
  @GetMapping("/ticketcustomsdeclarations" )
  public XfR getTicketCustomsDeclarations(XfPage page, TicketCustomsDeclaration ticketCustomsDeclaration) {
    return XfR.ok(ticketCustomsDeclarationServiceImpl.page(page, Wrappers.query(ticketCustomsDeclaration)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketcustomsdeclarations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketCustomsDeclaration ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketcustomsdeclarations")
  public XfR save(@RequestBody TicketCustomsDeclaration ticketCustomsDeclaration) {
     return XfR.ok(ticketCustomsDeclarationServiceImpl.save(ticketCustomsDeclaration));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketCustomsDeclaration ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketcustomsdeclarations/{id}")
  public XfR putUpdate(@RequestBody TicketCustomsDeclaration ticketCustomsDeclaration,@PathVariable Long id) {
      ticketCustomsDeclaration.setId(id);
      return XfR.ok(ticketCustomsDeclarationServiceImpl.updateById(ticketCustomsDeclaration));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketCustomsDeclaration ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketcustomsdeclarations/{id}")
  public XfR patchUpdate(@RequestBody TicketCustomsDeclaration ticketCustomsDeclaration,@PathVariable Long id) {
      TicketCustomsDeclaration upticketCustomsDeclaration = ticketCustomsDeclarationServiceImpl.getById(id);
      if(upticketCustomsDeclaration != null){
        upticketCustomsDeclaration = ObjectCopyUtils.copyProperties(ticketCustomsDeclaration,upticketCustomsDeclaration,true);
      }
      return XfR.ok(ticketCustomsDeclarationServiceImpl.updateById(upticketCustomsDeclaration));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketcustomsdeclarations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationServiceImpl.removeById(id));
  }

  @PostMapping("/ticketcustomsdeclarations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_customs_declaration");
     params.put("request", condition);

     return XfR.ok(ticketCustomsDeclarationServiceImpl.querys(params));
  }

}
