package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketCustomsDeclarationDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketCustomsDeclarationDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对海关报关单明细前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class CompareTicketCustomsDeclarationDetailController {

  @Autowired
  private ICompareTicketCustomsDeclarationDetailService compareTicketCustomsDeclarationDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return
   */
  @GetMapping("/compareticketcustomsdeclarationdetails" )
  public XfR getCompareTicketCustomsDeclarationDetails(XfPage page, CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail) {
    return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.page(page, Wrappers.query(compareTicketCustomsDeclarationDetail)));
  }

  /**
   * 通过id查询比对海关报关单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketcustomsdeclarationdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.getById(id));
  }

  /**
   * 新增比对海关报关单明细
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return XfR
   */
  @PostMapping("/compareticketcustomsdeclarationdetails")
  public XfR save(@RequestBody CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail) {
     return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.save(compareTicketCustomsDeclarationDetail));
  }

  /**
   * 修改-传入修改后的全部数据比对海关报关单明细
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return XfR
   */
  @PutMapping("/compareticketcustomsdeclarationdetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail,@PathVariable Long id) {
      compareTicketCustomsDeclarationDetail.setId(id);
      return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.updateById(compareTicketCustomsDeclarationDetail));
  }

  /**
   * 修改-传入修改的数据比对海关报关单明细
   * @param compareTicketCustomsDeclarationDetail 比对海关报关单明细
   * @return XfR
   */
  @PatchMapping("/compareticketcustomsdeclarationdetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketCustomsDeclarationDetail compareTicketCustomsDeclarationDetail,@PathVariable Long id) {
      CompareTicketCustomsDeclarationDetail upcompareTicketCustomsDeclarationDetail = compareTicketCustomsDeclarationDetailServiceImpl.getById(id);
      if(upcompareTicketCustomsDeclarationDetail != null){
        upcompareTicketCustomsDeclarationDetail = ObjectCopyUtils.copyProperties(compareTicketCustomsDeclarationDetail,upcompareTicketCustomsDeclarationDetail,true);
      }
      return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.updateById(upcompareTicketCustomsDeclarationDetail));
  }

  /**
   * 通过id删除比对海关报关单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketcustomsdeclarationdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketcustomsdeclarationdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_customs_declaration_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketCustomsDeclarationDetailServiceImpl.querys(params));
  }

}
