package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketMachineDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketMachineDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的通用机打发票明细前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class CompareTicketMachineDetailController {

  @Autowired
  private ICompareTicketMachineDetailService compareTicketMachineDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMachineDetail 数据比对用途的通用机打发票明细
   * @return
   */
  @GetMapping("/compareticketmachinedetails" )
  public XfR getCompareTicketMachineDetails(XfPage page, CompareTicketMachineDetail compareTicketMachineDetail) {
    return XfR.ok(compareTicketMachineDetailServiceImpl.page(page, Wrappers.query(compareTicketMachineDetail)));
  }

  /**
   * 通过id查询数据比对用途的通用机打发票明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmachinedetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketMachineDetailServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的通用机打发票明细
   * @param compareTicketMachineDetail 数据比对用途的通用机打发票明细
   * @return XfR
   */
  @PostMapping("/compareticketmachinedetails")
  public XfR save(@RequestBody CompareTicketMachineDetail compareTicketMachineDetail) {
     return XfR.ok(compareTicketMachineDetailServiceImpl.save(compareTicketMachineDetail));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的通用机打发票明细
   * @param compareTicketMachineDetail 数据比对用途的通用机打发票明细
   * @return XfR
   */
  @PutMapping("/compareticketmachinedetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMachineDetail compareTicketMachineDetail,@PathVariable Long id) {
      compareTicketMachineDetail.setId(id);
      return XfR.ok(compareTicketMachineDetailServiceImpl.updateById(compareTicketMachineDetail));
  }

  /**
   * 修改-传入修改的数据数据比对用途的通用机打发票明细
   * @param compareTicketMachineDetail 数据比对用途的通用机打发票明细
   * @return XfR
   */
  @PatchMapping("/compareticketmachinedetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMachineDetail compareTicketMachineDetail,@PathVariable Long id) {
      CompareTicketMachineDetail upcompareTicketMachineDetail = compareTicketMachineDetailServiceImpl.getById(id);
      if(upcompareTicketMachineDetail != null){
        upcompareTicketMachineDetail = ObjectCopyUtils.copyProperties(compareTicketMachineDetail,upcompareTicketMachineDetail,true);
      }
      return XfR.ok(compareTicketMachineDetailServiceImpl.updateById(upcompareTicketMachineDetail));
  }

  /**
   * 通过id删除数据比对用途的通用机打发票明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmachinedetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketMachineDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmachinedetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_machine_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketMachineDetailServiceImpl.querys(params));
  }

}
