package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketMedicalDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketMedicalDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对医疗票据明细前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class CompareTicketMedicalDetailController {

  @Autowired
  private ICompareTicketMedicalDetailService compareTicketMedicalDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return
   */
  @GetMapping("/compareticketmedicaldetails" )
  public XfR getCompareTicketMedicalDetails(XfPage page, CompareTicketMedicalDetail compareTicketMedicalDetail) {
    return XfR.ok(compareTicketMedicalDetailServiceImpl.page(page, Wrappers.query(compareTicketMedicalDetail)));
  }

  /**
   * 通过id查询比对医疗票据明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketmedicaldetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketMedicalDetailServiceImpl.getById(id));
  }

  /**
   * 新增比对医疗票据明细
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return XfR
   */
  @PostMapping("/compareticketmedicaldetails")
  public XfR save(@RequestBody CompareTicketMedicalDetail compareTicketMedicalDetail) {
     return XfR.ok(compareTicketMedicalDetailServiceImpl.save(compareTicketMedicalDetail));
  }

  /**
   * 修改-传入修改后的全部数据比对医疗票据明细
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return XfR
   */
  @PutMapping("/compareticketmedicaldetails/{id}")
  public XfR putUpdate(@RequestBody CompareTicketMedicalDetail compareTicketMedicalDetail,@PathVariable Long id) {
      compareTicketMedicalDetail.setId(id);
      return XfR.ok(compareTicketMedicalDetailServiceImpl.updateById(compareTicketMedicalDetail));
  }

  /**
   * 修改-传入修改的数据比对医疗票据明细
   * @param compareTicketMedicalDetail 比对医疗票据明细
   * @return XfR
   */
  @PatchMapping("/compareticketmedicaldetails/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketMedicalDetail compareTicketMedicalDetail,@PathVariable Long id) {
      CompareTicketMedicalDetail upcompareTicketMedicalDetail = compareTicketMedicalDetailServiceImpl.getById(id);
      if(upcompareTicketMedicalDetail != null){
        upcompareTicketMedicalDetail = ObjectCopyUtils.copyProperties(compareTicketMedicalDetail,upcompareTicketMedicalDetail,true);
      }
      return XfR.ok(compareTicketMedicalDetailServiceImpl.updateById(upcompareTicketMedicalDetail));
  }

  /**
   * 通过id删除比对医疗票据明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketmedicaldetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketMedicalDetailServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketmedicaldetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_medical_detail");
     params.put("request", condition);

     return XfR.ok(compareTicketMedicalDetailServiceImpl.querys(params));
  }

}
