package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketCustomsPayment;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketCustomsPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class TicketCustomsPaymentController {

  @Autowired
  private ITicketCustomsPaymentService ticketCustomsPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketCustomsPayment ${table.comment}
   * @return
   */
  @GetMapping("/ticketcustomspayments" )
  public XfR getTicketCustomsPayments(XfPage page, TicketCustomsPayment ticketCustomsPayment) {
    return XfR.ok(ticketCustomsPaymentServiceImpl.page(page, Wrappers.query(ticketCustomsPayment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketcustomspayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsPaymentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketCustomsPayment ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketcustomspayments")
  public XfR save(@RequestBody TicketCustomsPayment ticketCustomsPayment) {
     return XfR.ok(ticketCustomsPaymentServiceImpl.save(ticketCustomsPayment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketCustomsPayment ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketcustomspayments/{id}")
  public XfR putUpdate(@RequestBody TicketCustomsPayment ticketCustomsPayment,@PathVariable Long id) {
      ticketCustomsPayment.setId(id);
      return XfR.ok(ticketCustomsPaymentServiceImpl.updateById(ticketCustomsPayment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketCustomsPayment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketcustomspayments/{id}")
  public XfR patchUpdate(@RequestBody TicketCustomsPayment ticketCustomsPayment,@PathVariable Long id) {
      TicketCustomsPayment upticketCustomsPayment = ticketCustomsPaymentServiceImpl.getById(id);
      if(upticketCustomsPayment != null){
        upticketCustomsPayment = ObjectCopyUtils.copyProperties(ticketCustomsPayment,upticketCustomsPayment,true);
      }
      return XfR.ok(ticketCustomsPaymentServiceImpl.updateById(upticketCustomsPayment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketcustomspayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/ticketcustomspayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_customs_payment");
     params.put("request", condition);

     return XfR.ok(ticketCustomsPaymentServiceImpl.querys(params));
  }

}
