package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketCustomsPaymentDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketCustomsPaymentDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class TicketCustomsPaymentDetailController {

  @Autowired
  private ITicketCustomsPaymentDetailService ticketCustomsPaymentDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketCustomsPaymentDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketcustomspaymentdetails" )
  public XfR getTicketCustomsPaymentDetails(XfPage page, TicketCustomsPaymentDetail ticketCustomsPaymentDetail) {
    return XfR.ok(ticketCustomsPaymentDetailServiceImpl.page(page, Wrappers.query(ticketCustomsPaymentDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketcustomspaymentdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsPaymentDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketCustomsPaymentDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketcustomspaymentdetails")
  public XfR save(@RequestBody TicketCustomsPaymentDetail ticketCustomsPaymentDetail) {
     return XfR.ok(ticketCustomsPaymentDetailServiceImpl.save(ticketCustomsPaymentDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketCustomsPaymentDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketcustomspaymentdetails/{id}")
  public XfR putUpdate(@RequestBody TicketCustomsPaymentDetail ticketCustomsPaymentDetail,@PathVariable Long id) {
      ticketCustomsPaymentDetail.setId(id);
      return XfR.ok(ticketCustomsPaymentDetailServiceImpl.updateById(ticketCustomsPaymentDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketCustomsPaymentDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketcustomspaymentdetails/{id}")
  public XfR patchUpdate(@RequestBody TicketCustomsPaymentDetail ticketCustomsPaymentDetail,@PathVariable Long id) {
      TicketCustomsPaymentDetail upticketCustomsPaymentDetail = ticketCustomsPaymentDetailServiceImpl.getById(id);
      if(upticketCustomsPaymentDetail != null){
        upticketCustomsPaymentDetail = ObjectCopyUtils.copyProperties(ticketCustomsPaymentDetail,upticketCustomsPaymentDetail,true);
      }
      return XfR.ok(ticketCustomsPaymentDetailServiceImpl.updateById(upticketCustomsPaymentDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketcustomspaymentdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsPaymentDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketcustomspaymentdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_customs_payment_detail");
     params.put("request", condition);

     return XfR.ok(ticketCustomsPaymentDetailServiceImpl.querys(params));
  }

}
