package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.WithholdRemitPayment;
import com.xforceplus.ultraman.app.imagesaas.service.IWithholdRemitPaymentService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-07-13
 */
@RestController
public class WithholdRemitPaymentController {

  @Autowired
  private IWithholdRemitPaymentService withholdRemitPaymentServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param withholdRemitPayment ${table.comment}
   * @return
   */
  @GetMapping("/withholdremitpayments" )
  public XfR getWithholdRemitPayments(XfPage page, WithholdRemitPayment withholdRemitPayment) {
    return XfR.ok(withholdRemitPaymentServiceImpl.page(page, Wrappers.query(withholdRemitPayment)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/withholdremitpayments/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(withholdRemitPaymentServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param withholdRemitPayment ${table.comment}
   * @return XfR
   */
  @PostMapping("/withholdremitpayments")
  public XfR save(@RequestBody WithholdRemitPayment withholdRemitPayment) {
     return XfR.ok(withholdRemitPaymentServiceImpl.save(withholdRemitPayment));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param withholdRemitPayment ${table.comment}
   * @return XfR
   */
  @PutMapping("/withholdremitpayments/{id}")
  public XfR putUpdate(@RequestBody WithholdRemitPayment withholdRemitPayment,@PathVariable Long id) {
      withholdRemitPayment.setId(id);
      return XfR.ok(withholdRemitPaymentServiceImpl.updateById(withholdRemitPayment));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param withholdRemitPayment ${table.comment}
   * @return XfR
   */
  @PatchMapping("/withholdremitpayments/{id}")
  public XfR patchUpdate(@RequestBody WithholdRemitPayment withholdRemitPayment,@PathVariable Long id) {
      WithholdRemitPayment upwithholdRemitPayment = withholdRemitPaymentServiceImpl.getById(id);
      if(upwithholdRemitPayment != null){
        upwithholdRemitPayment = ObjectCopyUtils.copyProperties(withholdRemitPayment,upwithholdRemitPayment,true);
      }
      return XfR.ok(withholdRemitPaymentServiceImpl.updateById(upwithholdRemitPayment));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/withholdremitpayments/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(withholdRemitPaymentServiceImpl.removeById(id));
  }

  @PostMapping("/withholdremitpayments/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "withhold_remit_payment");
     params.put("request", condition);

     return XfR.ok(withholdRemitPaymentServiceImpl.querys(params));
  }

}
