package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CbHtfk;
import com.xforceplus.ultraman.app.imagesaas.service.ICbHtfkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 中南置地-成本合同付款前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class CbHtfkController {

  @Autowired
  private ICbHtfkService cbHtfkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cbHtfk 中南置地-成本合同付款
   * @return
   */
  @GetMapping("/cbhtfks" )
  public XfR getCbHtfks(XfPage page, CbHtfk cbHtfk) {
    return XfR.ok(cbHtfkServiceImpl.page(page, Wrappers.query(cbHtfk)));
  }

  /**
   * 通过id查询中南置地-成本合同付款
   * @param  id
   * @return XfR
   */
  @GetMapping("/cbhtfks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cbHtfkServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-成本合同付款
   * @param cbHtfk 中南置地-成本合同付款
   * @return XfR
   */
  @PostMapping("/cbhtfks")
  public XfR save(@RequestBody CbHtfk cbHtfk) {
     return XfR.ok(cbHtfkServiceImpl.save(cbHtfk));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-成本合同付款
   * @param cbHtfk 中南置地-成本合同付款
   * @return XfR
   */
  @PutMapping("/cbhtfks/{id}")
  public XfR putUpdate(@RequestBody CbHtfk cbHtfk,@PathVariable Long id) {
      cbHtfk.setId(id);
      return XfR.ok(cbHtfkServiceImpl.updateById(cbHtfk));
  }

  /**
   * 修改-传入修改的数据中南置地-成本合同付款
   * @param cbHtfk 中南置地-成本合同付款
   * @return XfR
   */
  @PatchMapping("/cbhtfks/{id}")
  public XfR patchUpdate(@RequestBody CbHtfk cbHtfk,@PathVariable Long id) {
      CbHtfk upcbHtfk = cbHtfkServiceImpl.getById(id);
      if(upcbHtfk != null){
        upcbHtfk = ObjectCopyUtils.copyProperties(cbHtfk,upcbHtfk,true);
      }
      return XfR.ok(cbHtfkServiceImpl.updateById(upcbHtfk));
  }

  /**
   * 通过id删除中南置地-成本合同付款
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cbhtfks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cbHtfkServiceImpl.removeById(id));
  }

  @PostMapping("/cbhtfks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cb_htfk");
     params.put("request", condition);

     return XfR.ok(cbHtfkServiceImpl.querys(params));
  }

}
