package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareBaseBill;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareBaseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的基础单据前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class CompareBaseBillController {

  @Autowired
  private ICompareBaseBillService compareBaseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareBaseBill 数据比对用途的基础单据
   * @return
   */
  @GetMapping("/comparebasebills" )
  public XfR getCompareBaseBills(XfPage page, CompareBaseBill compareBaseBill) {
    return XfR.ok(compareBaseBillServiceImpl.page(page, Wrappers.query(compareBaseBill)));
  }

  /**
   * 通过id查询数据比对用途的基础单据
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparebasebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareBaseBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的基础单据
   * @param compareBaseBill 数据比对用途的基础单据
   * @return XfR
   */
  @PostMapping("/comparebasebills")
  public XfR save(@RequestBody CompareBaseBill compareBaseBill) {
     return XfR.ok(compareBaseBillServiceImpl.save(compareBaseBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的基础单据
   * @param compareBaseBill 数据比对用途的基础单据
   * @return XfR
   */
  @PutMapping("/comparebasebills/{id}")
  public XfR putUpdate(@RequestBody CompareBaseBill compareBaseBill,@PathVariable Long id) {
      compareBaseBill.setId(id);
      return XfR.ok(compareBaseBillServiceImpl.updateById(compareBaseBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的基础单据
   * @param compareBaseBill 数据比对用途的基础单据
   * @return XfR
   */
  @PatchMapping("/comparebasebills/{id}")
  public XfR patchUpdate(@RequestBody CompareBaseBill compareBaseBill,@PathVariable Long id) {
      CompareBaseBill upcompareBaseBill = compareBaseBillServiceImpl.getById(id);
      if(upcompareBaseBill != null){
        upcompareBaseBill = ObjectCopyUtils.copyProperties(compareBaseBill,upcompareBaseBill,true);
      }
      return XfR.ok(compareBaseBillServiceImpl.updateById(upcompareBaseBill));
  }

  /**
   * 通过id删除数据比对用途的基础单据
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparebasebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareBaseBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparebasebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_base_bill");
     params.put("request", condition);

     return XfR.ok(compareBaseBillServiceImpl.querys(params));
  }

}
