package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareTicketTaxi;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareTicketTaxiService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 数据比对用途的出租车前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class CompareTicketTaxiController {

  @Autowired
  private ICompareTicketTaxiService compareTicketTaxiServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketTaxi 数据比对用途的出租车
   * @return
   */
  @GetMapping("/comparetickettaxis" )
  public XfR getCompareTicketTaxis(XfPage page, CompareTicketTaxi compareTicketTaxi) {
    return XfR.ok(compareTicketTaxiServiceImpl.page(page, Wrappers.query(compareTicketTaxi)));
  }

  /**
   * 通过id查询数据比对用途的出租车
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparetickettaxis/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketTaxiServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的出租车
   * @param compareTicketTaxi 数据比对用途的出租车
   * @return XfR
   */
  @PostMapping("/comparetickettaxis")
  public XfR save(@RequestBody CompareTicketTaxi compareTicketTaxi) {
     return XfR.ok(compareTicketTaxiServiceImpl.save(compareTicketTaxi));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的出租车
   * @param compareTicketTaxi 数据比对用途的出租车
   * @return XfR
   */
  @PutMapping("/comparetickettaxis/{id}")
  public XfR putUpdate(@RequestBody CompareTicketTaxi compareTicketTaxi,@PathVariable Long id) {
      compareTicketTaxi.setId(id);
      return XfR.ok(compareTicketTaxiServiceImpl.updateById(compareTicketTaxi));
  }

  /**
   * 修改-传入修改的数据数据比对用途的出租车
   * @param compareTicketTaxi 数据比对用途的出租车
   * @return XfR
   */
  @PatchMapping("/comparetickettaxis/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketTaxi compareTicketTaxi,@PathVariable Long id) {
      CompareTicketTaxi upcompareTicketTaxi = compareTicketTaxiServiceImpl.getById(id);
      if(upcompareTicketTaxi != null){
        upcompareTicketTaxi = ObjectCopyUtils.copyProperties(compareTicketTaxi,upcompareTicketTaxi,true);
      }
      return XfR.ok(compareTicketTaxiServiceImpl.updateById(upcompareTicketTaxi));
  }

  /**
   * 通过id删除数据比对用途的出租车
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparetickettaxis/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketTaxiServiceImpl.removeById(id));
  }

  @PostMapping("/comparetickettaxis/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_taxi");
     params.put("request", condition);

     return XfR.ok(compareTicketTaxiServiceImpl.querys(params));
  }

}
