package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketCustomsDeclarationDetail;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketCustomsDeclarationDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-12-01
 */
@RestController
public class TicketCustomsDeclarationDetailController {

  @Autowired
  private ITicketCustomsDeclarationDetailService ticketCustomsDeclarationDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketCustomsDeclarationDetail ${table.comment}
   * @return
   */
  @GetMapping("/ticketcustomsdeclarationdetails" )
  public XfR getTicketCustomsDeclarationDetails(XfPage page, TicketCustomsDeclarationDetail ticketCustomsDeclarationDetail) {
    return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.page(page, Wrappers.query(ticketCustomsDeclarationDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketcustomsdeclarationdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketCustomsDeclarationDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketcustomsdeclarationdetails")
  public XfR save(@RequestBody TicketCustomsDeclarationDetail ticketCustomsDeclarationDetail) {
     return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.save(ticketCustomsDeclarationDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketCustomsDeclarationDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketcustomsdeclarationdetails/{id}")
  public XfR putUpdate(@RequestBody TicketCustomsDeclarationDetail ticketCustomsDeclarationDetail,@PathVariable Long id) {
      ticketCustomsDeclarationDetail.setId(id);
      return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.updateById(ticketCustomsDeclarationDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketCustomsDeclarationDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketcustomsdeclarationdetails/{id}")
  public XfR patchUpdate(@RequestBody TicketCustomsDeclarationDetail ticketCustomsDeclarationDetail,@PathVariable Long id) {
      TicketCustomsDeclarationDetail upticketCustomsDeclarationDetail = ticketCustomsDeclarationDetailServiceImpl.getById(id);
      if(upticketCustomsDeclarationDetail != null){
        upticketCustomsDeclarationDetail = ObjectCopyUtils.copyProperties(ticketCustomsDeclarationDetail,upticketCustomsDeclarationDetail,true);
      }
      return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.updateById(upticketCustomsDeclarationDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketcustomsdeclarationdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.removeById(id));
  }

  @PostMapping("/ticketcustomsdeclarationdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_customs_declaration_detail");
     params.put("request", condition);

     return XfR.ok(ticketCustomsDeclarationDetailServiceImpl.querys(params));
  }

}
