package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.BaseBill;
import com.xforceplus.ultraman.app.imagesaas.service.IBaseBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class BaseBillController {

  @Autowired
  private IBaseBillService baseBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param baseBill ${table.comment}
   * @return
   */
  @GetMapping("/basebills" )
  public XfR getBaseBills(XfPage page, BaseBill baseBill) {
    return XfR.ok(baseBillServiceImpl.page(page, Wrappers.query(baseBill)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/basebills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(baseBillServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param baseBill ${table.comment}
   * @return XfR
   */
  @PostMapping("/basebills")
  public XfR save(@RequestBody BaseBill baseBill) {
     return XfR.ok(baseBillServiceImpl.save(baseBill));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param baseBill ${table.comment}
   * @return XfR
   */
  @PutMapping("/basebills/{id}")
  public XfR putUpdate(@RequestBody BaseBill baseBill,@PathVariable Long id) {
      baseBill.setId(id);
      return XfR.ok(baseBillServiceImpl.updateById(baseBill));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param baseBill ${table.comment}
   * @return XfR
   */
  @PatchMapping("/basebills/{id}")
  public XfR patchUpdate(@RequestBody BaseBill baseBill,@PathVariable Long id) {
      BaseBill upbaseBill = baseBillServiceImpl.getById(id);
      if(upbaseBill != null){
        upbaseBill = ObjectCopyUtils.copyProperties(baseBill,upbaseBill,true);
      }
      return XfR.ok(baseBillServiceImpl.updateById(upbaseBill));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/basebills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(baseBillServiceImpl.removeById(id));
  }

  @PostMapping("/basebills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "base_bill");
     params.put("request", condition);

     return XfR.ok(baseBillServiceImpl.querys(params));
  }

}
