package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CbFHtfk;
import com.xforceplus.ultraman.app.imagesaas.service.ICbFHtfkService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 中南置地-成本非合同付款前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class CbFHtfkController {

  @Autowired
  private ICbFHtfkService cbFHtfkServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param cbFHtfk 中南置地-成本非合同付款
   * @return
   */
  @GetMapping("/cbfhtfks" )
  public XfR getCbFHtfks(XfPage page, CbFHtfk cbFHtfk) {
    return XfR.ok(cbFHtfkServiceImpl.page(page, Wrappers.query(cbFHtfk)));
  }

  /**
   * 通过id查询中南置地-成本非合同付款
   * @param  id
   * @return XfR
   */
  @GetMapping("/cbfhtfks/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(cbFHtfkServiceImpl.getById(id));
  }

  /**
   * 新增中南置地-成本非合同付款
   * @param cbFHtfk 中南置地-成本非合同付款
   * @return XfR
   */
  @PostMapping("/cbfhtfks")
  public XfR save(@RequestBody CbFHtfk cbFHtfk) {
     return XfR.ok(cbFHtfkServiceImpl.save(cbFHtfk));
  }

  /**
   * 修改-传入修改后的全部数据中南置地-成本非合同付款
   * @param cbFHtfk 中南置地-成本非合同付款
   * @return XfR
   */
  @PutMapping("/cbfhtfks/{id}")
  public XfR putUpdate(@RequestBody CbFHtfk cbFHtfk,@PathVariable Long id) {
      cbFHtfk.setId(id);
      return XfR.ok(cbFHtfkServiceImpl.updateById(cbFHtfk));
  }

  /**
   * 修改-传入修改的数据中南置地-成本非合同付款
   * @param cbFHtfk 中南置地-成本非合同付款
   * @return XfR
   */
  @PatchMapping("/cbfhtfks/{id}")
  public XfR patchUpdate(@RequestBody CbFHtfk cbFHtfk,@PathVariable Long id) {
      CbFHtfk upcbFHtfk = cbFHtfkServiceImpl.getById(id);
      if(upcbFHtfk != null){
        upcbFHtfk = ObjectCopyUtils.copyProperties(cbFHtfk,upcbFHtfk,true);
      }
      return XfR.ok(cbFHtfkServiceImpl.updateById(upcbFHtfk));
  }

  /**
   * 通过id删除中南置地-成本非合同付款
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/cbfhtfks/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(cbFHtfkServiceImpl.removeById(id));
  }

  @PostMapping("/cbfhtfks/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "cb_f_htfk");
     params.put("request", condition);

     return XfR.ok(cbFHtfkServiceImpl.querys(params));
  }

}
