package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareConfig;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareConfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class CompareConfigController {

  @Autowired
  private ICompareConfigService compareConfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareConfig ${table.comment}
   * @return
   */
  @GetMapping("/compareconfigs" )
  public XfR getCompareConfigs(XfPage page, CompareConfig compareConfig) {
    return XfR.ok(compareConfigServiceImpl.page(page, Wrappers.query(compareConfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareConfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param compareConfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/compareconfigs")
  public XfR save(@RequestBody CompareConfig compareConfig) {
     return XfR.ok(compareConfigServiceImpl.save(compareConfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param compareConfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/compareconfigs/{id}")
  public XfR putUpdate(@RequestBody CompareConfig compareConfig,@PathVariable Long id) {
      compareConfig.setId(id);
      return XfR.ok(compareConfigServiceImpl.updateById(compareConfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param compareConfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/compareconfigs/{id}")
  public XfR patchUpdate(@RequestBody CompareConfig compareConfig,@PathVariable Long id) {
      CompareConfig upcompareConfig = compareConfigServiceImpl.getById(id);
      if(upcompareConfig != null){
        upcompareConfig = ObjectCopyUtils.copyProperties(compareConfig,upcompareConfig,true);
      }
      return XfR.ok(compareConfigServiceImpl.updateById(upcompareConfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareConfigServiceImpl.removeById(id));
  }

  @PostMapping("/compareconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_config");
     params.put("request", condition);

     return XfR.ok(compareConfigServiceImpl.querys(params));
  }

}
