package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.CompareStatementBill;
import com.xforceplus.ultraman.app.imagesaas.service.ICompareStatementBillService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 数据比对用途的对账单前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class CompareStatementBillController {

  @Autowired
  private ICompareStatementBillService compareStatementBillServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareStatementBill 数据比对用途的对账单
   * @return
   */
  @GetMapping("/comparestatementbills" )
  public XfR getCompareStatementBills(XfPage page, CompareStatementBill compareStatementBill) {
    return XfR.ok(compareStatementBillServiceImpl.page(page, Wrappers.query(compareStatementBill)));
  }

  /**
   * 通过id查询数据比对用途的对账单
   * @param  id
   * @return XfR
   */
  @GetMapping("/comparestatementbills/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareStatementBillServiceImpl.getById(id));
  }

  /**
   * 新增数据比对用途的对账单
   * @param compareStatementBill 数据比对用途的对账单
   * @return XfR
   */
  @PostMapping("/comparestatementbills")
  public XfR save(@RequestBody CompareStatementBill compareStatementBill) {
     return XfR.ok(compareStatementBillServiceImpl.save(compareStatementBill));
  }

  /**
   * 修改-传入修改后的全部数据数据比对用途的对账单
   * @param compareStatementBill 数据比对用途的对账单
   * @return XfR
   */
  @PutMapping("/comparestatementbills/{id}")
  public XfR putUpdate(@RequestBody CompareStatementBill compareStatementBill,@PathVariable Long id) {
      compareStatementBill.setId(id);
      return XfR.ok(compareStatementBillServiceImpl.updateById(compareStatementBill));
  }

  /**
   * 修改-传入修改的数据数据比对用途的对账单
   * @param compareStatementBill 数据比对用途的对账单
   * @return XfR
   */
  @PatchMapping("/comparestatementbills/{id}")
  public XfR patchUpdate(@RequestBody CompareStatementBill compareStatementBill,@PathVariable Long id) {
      CompareStatementBill upcompareStatementBill = compareStatementBillServiceImpl.getById(id);
      if(upcompareStatementBill != null){
        upcompareStatementBill = ObjectCopyUtils.copyProperties(compareStatementBill,upcompareStatementBill,true);
      }
      return XfR.ok(compareStatementBillServiceImpl.updateById(upcompareStatementBill));
  }

  /**
   * 通过id删除数据比对用途的对账单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/comparestatementbills/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareStatementBillServiceImpl.removeById(id));
  }

  @PostMapping("/comparestatementbills/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_statement_bill");
     params.put("request", condition);

     return XfR.ok(compareStatementBillServiceImpl.querys(params));
  }

}
