package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.InvoicePlane;
import com.xforceplus.ultraman.app.imagesaas.service.IInvoicePlaneService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class InvoicePlaneController {

  @Autowired
  private IInvoicePlaneService invoicePlaneServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoicePlane ${table.comment}
   * @return
   */
  @GetMapping("/invoiceplanes" )
  public XfR getInvoicePlanes(XfPage page, InvoicePlane invoicePlane) {
    return XfR.ok(invoicePlaneServiceImpl.page(page, Wrappers.query(invoicePlane)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoiceplanes/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoicePlaneServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoicePlane ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoiceplanes")
  public XfR save(@RequestBody InvoicePlane invoicePlane) {
     return XfR.ok(invoicePlaneServiceImpl.save(invoicePlane));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoicePlane ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoiceplanes/{id}")
  public XfR putUpdate(@RequestBody InvoicePlane invoicePlane,@PathVariable Long id) {
      invoicePlane.setId(id);
      return XfR.ok(invoicePlaneServiceImpl.updateById(invoicePlane));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoicePlane ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoiceplanes/{id}")
  public XfR patchUpdate(@RequestBody InvoicePlane invoicePlane,@PathVariable Long id) {
      InvoicePlane upinvoicePlane = invoicePlaneServiceImpl.getById(id);
      if(upinvoicePlane != null){
        upinvoicePlane = ObjectCopyUtils.copyProperties(invoicePlane,upinvoicePlane,true);
      }
      return XfR.ok(invoicePlaneServiceImpl.updateById(upinvoicePlane));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoiceplanes/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoicePlaneServiceImpl.removeById(id));
  }

  @PostMapping("/invoiceplanes/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_plane");
     params.put("request", condition);

     return XfR.ok(invoicePlaneServiceImpl.querys(params));
  }

}
