package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.InvoiceTrain;
import com.xforceplus.ultraman.app.imagesaas.service.IInvoiceTrainService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class InvoiceTrainController {

  @Autowired
  private IInvoiceTrainService invoiceTrainServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param invoiceTrain ${table.comment}
   * @return
   */
  @GetMapping("/invoicetrains" )
  public XfR getInvoiceTrains(XfPage page, InvoiceTrain invoiceTrain) {
    return XfR.ok(invoiceTrainServiceImpl.page(page, Wrappers.query(invoiceTrain)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/invoicetrains/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(invoiceTrainServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param invoiceTrain ${table.comment}
   * @return XfR
   */
  @PostMapping("/invoicetrains")
  public XfR save(@RequestBody InvoiceTrain invoiceTrain) {
     return XfR.ok(invoiceTrainServiceImpl.save(invoiceTrain));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param invoiceTrain ${table.comment}
   * @return XfR
   */
  @PutMapping("/invoicetrains/{id}")
  public XfR putUpdate(@RequestBody InvoiceTrain invoiceTrain,@PathVariable Long id) {
      invoiceTrain.setId(id);
      return XfR.ok(invoiceTrainServiceImpl.updateById(invoiceTrain));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param invoiceTrain ${table.comment}
   * @return XfR
   */
  @PatchMapping("/invoicetrains/{id}")
  public XfR patchUpdate(@RequestBody InvoiceTrain invoiceTrain,@PathVariable Long id) {
      InvoiceTrain upinvoiceTrain = invoiceTrainServiceImpl.getById(id);
      if(upinvoiceTrain != null){
        upinvoiceTrain = ObjectCopyUtils.copyProperties(invoiceTrain,upinvoiceTrain,true);
      }
      return XfR.ok(invoiceTrainServiceImpl.updateById(upinvoiceTrain));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/invoicetrains/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(invoiceTrainServiceImpl.removeById(id));
  }

  @PostMapping("/invoicetrains/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "invoice_train");
     params.put("request", condition);

     return XfR.ok(invoiceTrainServiceImpl.querys(params));
  }

}
