package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketDuplicateFields;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketDuplicateFieldsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class TicketDuplicateFieldsController {

  @Autowired
  private ITicketDuplicateFieldsService ticketDuplicateFieldsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketDuplicateFields ${table.comment}
   * @return
   */
  @GetMapping("/ticketduplicatefieldss" )
  public XfR getTicketDuplicateFieldss(XfPage page, TicketDuplicateFields ticketDuplicateFields) {
    return XfR.ok(ticketDuplicateFieldsServiceImpl.page(page, Wrappers.query(ticketDuplicateFields)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketduplicatefieldss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketDuplicateFieldsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketDuplicateFields ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketduplicatefieldss")
  public XfR save(@RequestBody TicketDuplicateFields ticketDuplicateFields) {
     return XfR.ok(ticketDuplicateFieldsServiceImpl.save(ticketDuplicateFields));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketDuplicateFields ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketduplicatefieldss/{id}")
  public XfR putUpdate(@RequestBody TicketDuplicateFields ticketDuplicateFields,@PathVariable Long id) {
      ticketDuplicateFields.setId(id);
      return XfR.ok(ticketDuplicateFieldsServiceImpl.updateById(ticketDuplicateFields));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketDuplicateFields ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketduplicatefieldss/{id}")
  public XfR patchUpdate(@RequestBody TicketDuplicateFields ticketDuplicateFields,@PathVariable Long id) {
      TicketDuplicateFields upticketDuplicateFields = ticketDuplicateFieldsServiceImpl.getById(id);
      if(upticketDuplicateFields != null){
        upticketDuplicateFields = ObjectCopyUtils.copyProperties(ticketDuplicateFields,upticketDuplicateFields,true);
      }
      return XfR.ok(ticketDuplicateFieldsServiceImpl.updateById(upticketDuplicateFields));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketduplicatefieldss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketDuplicateFieldsServiceImpl.removeById(id));
  }

  @PostMapping("/ticketduplicatefieldss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_duplicate_fields");
     params.put("request", condition);

     return XfR.ok(ticketDuplicateFieldsServiceImpl.querys(params));
  }

}
