package com.xforceplus.ultraman.app.imagesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imagesaas.entity.TicketQuota;
import com.xforceplus.ultraman.app.imagesaas.service.ITicketQuotaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2023-11-28
 */
@RestController
public class TicketQuotaController {

  @Autowired
  private ITicketQuotaService ticketQuotaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ticketQuota ${table.comment}
   * @return
   */
  @GetMapping("/ticketquotas" )
  public XfR getTicketQuotas(XfPage page, TicketQuota ticketQuota) {
    return XfR.ok(ticketQuotaServiceImpl.page(page, Wrappers.query(ticketQuota)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/ticketquotas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ticketQuotaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param ticketQuota ${table.comment}
   * @return XfR
   */
  @PostMapping("/ticketquotas")
  public XfR save(@RequestBody TicketQuota ticketQuota) {
     return XfR.ok(ticketQuotaServiceImpl.save(ticketQuota));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param ticketQuota ${table.comment}
   * @return XfR
   */
  @PutMapping("/ticketquotas/{id}")
  public XfR putUpdate(@RequestBody TicketQuota ticketQuota,@PathVariable Long id) {
      ticketQuota.setId(id);
      return XfR.ok(ticketQuotaServiceImpl.updateById(ticketQuota));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param ticketQuota ${table.comment}
   * @return XfR
   */
  @PatchMapping("/ticketquotas/{id}")
  public XfR patchUpdate(@RequestBody TicketQuota ticketQuota,@PathVariable Long id) {
      TicketQuota upticketQuota = ticketQuotaServiceImpl.getById(id);
      if(upticketQuota != null){
        upticketQuota = ObjectCopyUtils.copyProperties(ticketQuota,upticketQuota,true);
      }
      return XfR.ok(ticketQuotaServiceImpl.updateById(upticketQuota));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ticketquotas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ticketQuotaServiceImpl.removeById(id));
  }

  @PostMapping("/ticketquotas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ticket_quota");
     params.put("request", condition);

     return XfR.ok(ticketQuotaServiceImpl.querys(params));
  }

}
