package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 批次号规则feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.BatchNumberRule;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface BatchNumberRuleFeignApi {

  /**
   * 通过id查询批次号规则
   * @param  id
   * @return R
   */
  @GetMapping("/batchNumberRule/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增批次号规则
   * @param batchNumberRule 批次号规则
   * @return R
   */
  @PostMapping("/batchNumberRule/add")
  public R save(@RequestBody BatchNumberRule batchNumberRule);

  /**
   * 修改批次号规则
   * @param batchNumberRule 批次号规则
   * @return R
   */
  @PostMapping("/batchNumberRule/update")
  public R updateById(@RequestBody BatchNumberRule batchNumberRule);

  /**
   * 通过id删除批次号规则
   * @param  id
   * @return R
   */
  @DeleteMapping("/batchNumberRule/del/{id}" )
  public R removeById(@PathVariable Long id);

}