package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 比对进口发票明细feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicketImportDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketImportDetailFeignApi {

  /**
   * 通过id查询比对进口发票明细
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketImportDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对进口发票明细
   * @param compareTicketImportDetail 比对进口发票明细
   * @return R
   */
  @PostMapping("/compareTicketImportDetail/add")
  public R save(@RequestBody CompareTicketImportDetail compareTicketImportDetail);

  /**
   * 修改比对进口发票明细
   * @param compareTicketImportDetail 比对进口发票明细
   * @return R
   */
  @PostMapping("/compareTicketImportDetail/update")
  public R updateById(@RequestBody CompareTicketImportDetail compareTicketImportDetail);

  /**
   * 通过id删除比对进口发票明细
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketImportDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}