package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 数据比对用途的增值税发票feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicketInvoice;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketInvoiceFeignApi {

  /**
   * 通过id查询数据比对用途的增值税发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketInvoice/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的增值税发票
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return R
   */
  @PostMapping("/compareTicketInvoice/add")
  public R save(@RequestBody CompareTicketInvoice compareTicketInvoice);

  /**
   * 修改数据比对用途的增值税发票
   * @param compareTicketInvoice 数据比对用途的增值税发票
   * @return R
   */
  @PostMapping("/compareTicketInvoice/update")
  public R updateById(@RequestBody CompareTicketInvoice compareTicketInvoice);

  /**
   * 通过id删除数据比对用途的增值税发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketInvoice/del/{id}" )
  public R removeById(@PathVariable Long id);

}