package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 比对虚拟单证feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicketVirtual;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketVirtualFeignApi {

  /**
   * 通过id查询比对虚拟单证
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketVirtual/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对虚拟单证
   * @param compareTicketVirtual 比对虚拟单证
   * @return R
   */
  @PostMapping("/compareTicketVirtual/add")
  public R save(@RequestBody CompareTicketVirtual compareTicketVirtual);

  /**
   * 修改比对虚拟单证
   * @param compareTicketVirtual 比对虚拟单证
   * @return R
   */
  @PostMapping("/compareTicketVirtual/update")
  public R updateById(@RequestBody CompareTicketVirtual compareTicketVirtual);

  /**
   * 通过id删除比对虚拟单证
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketVirtual/del/{id}" )
  public R removeById(@PathVariable Long id);

}