package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 费用报销单feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.ExpensesBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface ExpensesBillFeignApi {

  /**
   * 通过id查询费用报销单
   * @param  id
   * @return R
   */
  @GetMapping("/expensesBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增费用报销单
   * @param expensesBill 费用报销单
   * @return R
   */
  @PostMapping("/expensesBill/add")
  public R save(@RequestBody ExpensesBill expensesBill);

  /**
   * 修改费用报销单
   * @param expensesBill 费用报销单
   * @return R
   */
  @PostMapping("/expensesBill/update")
  public R updateById(@RequestBody ExpensesBill expensesBill);

  /**
   * 通过id删除费用报销单
   * @param  id
   * @return R
   */
  @DeleteMapping("/expensesBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}