package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 影像关系表feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.ImageIndex;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface ImageIndexFeignApi {

  /**
   * 通过id查询影像关系表
   * @param  id
   * @return R
   */
  @GetMapping("/imageIndex/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增影像关系表
   * @param imageIndex 影像关系表
   * @return R
   */
  @PostMapping("/imageIndex/add")
  public R save(@RequestBody ImageIndex imageIndex);

  /**
   * 修改影像关系表
   * @param imageIndex 影像关系表
   * @return R
   */
  @PostMapping("/imageIndex/update")
  public R updateById(@RequestBody ImageIndex imageIndex);

  /**
   * 通过id删除影像关系表
   * @param  id
   * @return R
   */
  @DeleteMapping("/imageIndex/del/{id}" )
  public R removeById(@PathVariable Long id);

}