package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.ProjectFunction;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface ProjectFunctionFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/projectFunction/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param projectFunction ${table.comment}
   * @return R
   */
  @PostMapping("/projectFunction/add")
  public R save(@RequestBody ProjectFunction projectFunction);

  /**
   * 修改${table.comment}
   * @param projectFunction ${table.comment}
   * @return R
   */
  @PostMapping("/projectFunction/update")
  public R updateById(@RequestBody ProjectFunction projectFunction);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/projectFunction/del/{id}" )
  public R removeById(@PathVariable Long id);

}