package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 对账单feign客户端
 *
 * @author ultraman
 * @date 2024-09-10
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.StatementBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface StatementBillFeignApi {

  /**
   * 通过id查询对账单
   * @param  id
   * @return R
   */
  @GetMapping("/statementBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增对账单
   * @param statementBill 对账单
   * @return R
   */
  @PostMapping("/statementBill/add")
  public R save(@RequestBody StatementBill statementBill);

  /**
   * 修改对账单
   * @param statementBill 对账单
   * @return R
   */
  @PostMapping("/statementBill/update")
  public R updateById(@RequestBody StatementBill statementBill);

  /**
   * 通过id删除对账单
   * @param  id
   * @return R
   */
  @DeleteMapping("/statementBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}