package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 数据比对用途的 费用报销费用单feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareExpensesBill;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareExpensesBillFeignApi {

  /**
   * 通过id查询数据比对用途的 费用报销费用单
   * @param  id
   * @return R
   */
  @GetMapping("/compareExpensesBill/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增数据比对用途的 费用报销费用单
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return R
   */
  @PostMapping("/compareExpensesBill/add")
  public R save(@RequestBody CompareExpensesBill compareExpensesBill);

  /**
   * 修改数据比对用途的 费用报销费用单
   * @param compareExpensesBill 数据比对用途的 费用报销费用单
   * @return R
   */
  @PostMapping("/compareExpensesBill/update")
  public R updateById(@RequestBody CompareExpensesBill compareExpensesBill);

  /**
   * 通过id删除数据比对用途的 费用报销费用单
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareExpensesBill/del/{id}" )
  public R removeById(@PathVariable Long id);

}