package com.xforceplus.ultraman.app.imageservicesaas.controller;


/**
 * 比对进口发票feign客户端
 *
 * @author ultraman
 * @date 2025-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicketImport;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "image-service-saas")
public interface CompareTicketImportFeignApi {

  /**
   * 通过id查询比对进口发票
   * @param  id
   * @return R
   */
  @GetMapping("/compareTicketImport/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增比对进口发票
   * @param compareTicketImport 比对进口发票
   * @return R
   */
  @PostMapping("/compareTicketImport/add")
  public R save(@RequestBody CompareTicketImport compareTicketImport);

  /**
   * 修改比对进口发票
   * @param compareTicketImport 比对进口发票
   * @return R
   */
  @PostMapping("/compareTicketImport/update")
  public R updateById(@RequestBody CompareTicketImport compareTicketImport);

  /**
   * 通过id删除比对进口发票
   * @param  id
   * @return R
   */
  @DeleteMapping("/compareTicketImport/del/{id}" )
  public R removeById(@PathVariable Long id);

}