package com.xforceplus.ultraman.app.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * async_task_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum AsyncTaskStatus {

    WAIT("wait", "待处理"),
    ING("ing", "处理中"),
    DONE("done", "已经处理");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AsyncTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AsyncTaskStatus fromCode(String code){
        switch(code) {
            case "wait":
                return WAIT;
            case "ing":
                return ING;
            case "done":
                return DONE;
            default:
                return null;
        }
    }
}
