package com.xforceplus.ultraman.app.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_usage_ytjt
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum InvoiceUsageYTJT {

    _0("0", "联营"),
    _1("1", "经销"),
    _2("2", "代销"),
    _3("3", "储值卡"),
    _4("4", "全渠道"),
    _5("5", "特殊付款"),
    _6("6", "辅营采购"),
    _7("7", "采购"),
    _8("8", "对公付款");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceUsageYTJT(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceUsageYTJT fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "8":
                return _8;
            default:
                return null;
        }
    }
}
