package com.xforceplus.ultraman.app.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * reimbursement_status
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum ReimbursementStatus {

    _0("0", "未报销"),
    _2("2", "已报销");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ReimbursementStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ReimbursementStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
