package com.xforceplus.ultraman.app.imageservicesaas.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * ticket_check_icons
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
public enum TicketCheckIcons {

    BASE_CHECK("base_check", "基"),
    TITLE_CHECK("title_check", "购"),
    BLACKLIST_CHECK("blacklist_check", "黑"),
    SENSITIVE_CHECK("sensitive_check", "敏"),
    COORDINATION_CHECK("coordination_check", "销"),
    ELECTRONIC_CHECK("electronic_check", "匹"),
    ERROR_CODE_NO_CHECK("error_code_no_check", "串"),
    INVOICE_STATUS_CHECK("invoice_status_check", "状"),
    IS_REPLACE_CHECK("is_replace_check", "代"),
    LEGAL_PERSON_CHECK("legal_person_check", "主"),
    PERSON_CHECK("person_check", "购"),
    REPEAT_CHECK("repeat_check", "重"),
    SALES_LIST_CHECK("sales_list_check", "货"),
    CONSECUTIVE_CHECK("consecutive_check", "连"),
    SHEET_CHECK("sheet_check", "缺"),
    STAMPER_CHECK("stamper_check", "章"),
    USER_AUTH_CHECK("user_auth_check", "权"),
    VERIFY_RESULT_CHECK("verify_result_check", "验"),
    SIGN_RESULT_CHECK("sign_result_check", "签"),
    PURCHASE_REPEAT_CHECK("purchase_repeat_check", "重"),
    SHEET_DEDUCT_CHECK("sheet_deduct_check", "抵"),
    TICKET_REMARK_CHECK("ticket_remark_check", "备"),
    REC_FAILED_CHECK("rec_failed_check", "识"),
    USED_AMOUNT_CHECK("used_amount_check", "提"),
    CUSTOMS_PAYMENT_CHECK("customs_payment_check", "海"),
    INVOICE_PURCHASER_TAX_NO_CHECK("invoice_purchaser_tax_no_check", "税"),
    ALL_ELECTRIC_AUTH_CHECK("all_electric_auth_check", "全"),
    IS_COVER_TICKET_CHECK("is_cover_ticket_check", "覆"),
    BALANCE_AMOUNT_CHECK("balance_amount_check", "余"),
    PURCHASE_COOPERATE_CHECK("purchase_cooperate_check", "回"),
    SPECIAL_INVOICE_CHECK("special_invoice_check", "特"),
    TICKET_BANK_CHECK("ticket_bank_check", "银"),
    SALES_LIST_STAMPER_CHECK("sales_list_stamper_check", "章"),
    TICKET_UPLOAD_CHECK("ticket_upload_check", "传"),
    TRANSFORM_RESULT_CHECK("transform_result_check", "转"),
    SYSTEM_ORIG_CHECK("system_orig_check", "源"),
    GOODS_WHITELIST_CHECK("goods_whitelist_check", "商"),
    REMARK_WHITELIST_CHECK("remark_whitelist_check", "备"),
    BUSINESS_LICENSE_CHECK("business_license_check", "营"),
    OCR_VERIFY_CHANGE_CHECK("ocr_verify_change_check", "误");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TicketCheckIcons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TicketCheckIcons fromCode(String code){
        switch(code) {
            case "base_check":
                return BASE_CHECK;
            case "title_check":
                return TITLE_CHECK;
            case "blacklist_check":
                return BLACKLIST_CHECK;
            case "sensitive_check":
                return SENSITIVE_CHECK;
            case "coordination_check":
                return COORDINATION_CHECK;
            case "electronic_check":
                return ELECTRONIC_CHECK;
            case "error_code_no_check":
                return ERROR_CODE_NO_CHECK;
            case "invoice_status_check":
                return INVOICE_STATUS_CHECK;
            case "is_replace_check":
                return IS_REPLACE_CHECK;
            case "legal_person_check":
                return LEGAL_PERSON_CHECK;
            case "person_check":
                return PERSON_CHECK;
            case "repeat_check":
                return REPEAT_CHECK;
            case "sales_list_check":
                return SALES_LIST_CHECK;
            case "consecutive_check":
                return CONSECUTIVE_CHECK;
            case "sheet_check":
                return SHEET_CHECK;
            case "stamper_check":
                return STAMPER_CHECK;
            case "user_auth_check":
                return USER_AUTH_CHECK;
            case "verify_result_check":
                return VERIFY_RESULT_CHECK;
            case "sign_result_check":
                return SIGN_RESULT_CHECK;
            case "purchase_repeat_check":
                return PURCHASE_REPEAT_CHECK;
            case "sheet_deduct_check":
                return SHEET_DEDUCT_CHECK;
            case "ticket_remark_check":
                return TICKET_REMARK_CHECK;
            case "rec_failed_check":
                return REC_FAILED_CHECK;
            case "used_amount_check":
                return USED_AMOUNT_CHECK;
            case "customs_payment_check":
                return CUSTOMS_PAYMENT_CHECK;
            case "invoice_purchaser_tax_no_check":
                return INVOICE_PURCHASER_TAX_NO_CHECK;
            case "all_electric_auth_check":
                return ALL_ELECTRIC_AUTH_CHECK;
            case "is_cover_ticket_check":
                return IS_COVER_TICKET_CHECK;
            case "balance_amount_check":
                return BALANCE_AMOUNT_CHECK;
            case "purchase_cooperate_check":
                return PURCHASE_COOPERATE_CHECK;
            case "special_invoice_check":
                return SPECIAL_INVOICE_CHECK;
            case "ticket_bank_check":
                return TICKET_BANK_CHECK;
            case "sales_list_stamper_check":
                return SALES_LIST_STAMPER_CHECK;
            case "ticket_upload_check":
                return TICKET_UPLOAD_CHECK;
            case "transform_result_check":
                return TRANSFORM_RESULT_CHECK;
            case "system_orig_check":
                return SYSTEM_ORIG_CHECK;
            case "goods_whitelist_check":
                return GOODS_WHITELIST_CHECK;
            case "remark_whitelist_check":
                return REMARK_WHITELIST_CHECK;
            case "business_license_check":
                return BUSINESS_LICENSE_CHECK;
            case "ocr_verify_change_check":
                return OCR_VERIFY_CHANGE_CHECK;
            default:
                return null;
        }
    }
}
