package com.xforceplus.ultraman.app.imageservicesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BaseBill implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 影像ID
   */
  private Long imageId;

  /**
   * 批次号
   */
  private String batchNo;

  /**
   * 单据对象code
   */
  private String billTypeCode;

  /**
   * 单据号
   */
  private String billCode;

  /**
   * 单据金额
   */
  private BigDecimal billAmountWithTax;

  /**
   * 单据含税金额
   */
  private BigDecimal billTaxAmount;

  /**
   * 单据不含税金额
   */
  private BigDecimal billAmountWithoutTax;

  /**
   * 提单人
   */
  private String billCreateUser;

  /**
   * 提单日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCreateTime;

  /**
   * 扫描人ID
   */
  private Long scanUserId;

  /**
   * 扫描人姓名
   */
  private String scanUserName;

  /**
   * 扫描时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime scanCreateTime;

  /**
   * 运单号
   */
  private String packageCode;

  /**
   * 物流状态
   */
  private String logisticsStatus;

  /**
   * 寄送时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime logisticsTime;

  /**
   * 签收状态
   */
  private String signStatus;

  /**
   * 签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime signTime;

  /**
   * 是否公共
   */
  private String isPublic;

  /**
   * 物流备注
   */
  private String logisticRemark;

  /**
   * 挂起原因类型
   */
  private String hangType;

  /**
   * 挂起原因
   */
  private String hangReason;

  /**
   * 退回类型
   */
  private String backType;

  /**
   * 退回原因
   */
  private String backReason;

  /**
   * 单据状态
   */
  private String billDataStatus;

  /**
   * 状态变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billDataTime;

  /**
   * 核验签收状态
   */
  private String verifyStatus;

  /**
   * 核验签收时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime verifyTime;

  /**
   * 单据下的单证影像数量
   */
  private Long ticketCount;

  /**
   * 已有影像张数
   */
  private Long imageCount;

  /**
   * 异常数
   */
  private Long exceptionCount;

  /**
   * 预警数
   */
  private Long warningCount;

  /**
   * 单据是否异常
   */
  private String isException;

  /**
   * 单据异常信息
   */
  private String exceptionInfo;

  /**
   * 系统来源
   */
  private String systemOrig;

  /**
   * 是否敏感
   */
  private String isSecret;

  /**
   * 退回备注
   */
  private String backRemark;

  /**
   * 核验不合格类型
   */
  private String unqualityType;

  /**
   * 核验不合格原因
   */
  private String unqualityReason;

  /**
   * 核验挂起原因
   */
  private String verifyHangType;

  /**
   * 核验挂起备注
   */
  private String verifyHangReason;

  /**
   * id
   */
  private Long id;

  /**
   * 租户id
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否预付款
   */
  private String isPrepayment;

  /**
   * 扩展字段
   */
  private String extFields;

  /**
   * 外部状态
   */
  private String extStatus;

  /**
   * 预付款状态
   */
  private String prepaymentStatus;

  /**
   * 预付款变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime prepaymentTime;

  /**
   * 创建用户代码
   */
  private String createUserCode;

  /**
   * 销方税号
   */
  private String sellerTaxNo;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 购方税号
   */
  private String purchaserTaxNo;

  /**
   * 购方名称
   */
  private String purchaserName;

  /**
   * 流水号
   */
  private String serialNumber;

  /**
   * 单据校验状态
   */
  private String billCheckStatus;

  /**
   * 购方代码
   */
  private String purchaserCode;

  /**
   * 单据校验状态变更时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime billCheckTime;

  /**
   * 备注
   */
  private String remark;

  /**
   * 销方代码
   */
  private String sellerCode;

  /**
   * 租户名称
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 退回来源
   */
  private String backOrig;

  /**
   * 计算状态
   */
  private String calculateStatus;

  /**
   * 是否预警
   */
  private String isWarning;

  /**
   * 单据预警信息
   */
  private String warningInfo;

  /**
   * 购方编号
   */
  private String purchaserNo;

  /**
   * 退回人
   */
  private String backUser;

  /**
   * 保留字段1
   */
  private String reserved1;

  /**
   * 保留字段2
   */
  private String reserved2;

  /**
   * 保留字段3
   */
  private String reserved3;

  /**
   * 是否提交
   */
  private String isCommit;

  /**
   * 提交人ID
   */
  private Long commitUserId;

  /**
   * 提交人姓名
   */
  private String commitUserName;

  /**
   * 提交时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime commitTime;

  /**
   * 上传状态
   */
  private String uploadStatus;

  /**
   * 所属组织ID
   */
  private Long orgId;

  /**
   * 所属组织
   */
  private String orgName;

  /**
   * 所属组织代码
   */
  private String orgCode;

  /**
   * 是否推送单据
   */
  private String isPushBill;

  /**
   * 是否替换封面
   */
  private String isCover;

  /**
   * 系统来源
   */
  private String systemSource;

  /**
   * 是否新增
   */
  private String isAdd;

  /**
   * 是否变更
   */
  private String isChange;

  /**
   * 业务子类型
   */
  private String businessType;

  /**
   * 外部业务单号
   */
  private String settlementNo;

  /**
   * 单据用途
   */
  private String billUse;

  /**
   * 外部系统来源
   */
  private String systemOrigExternal;

  /**
   * 比对结果
   */
  private String compareStatus;

  /**
   * 稽核状态
   */
  private String auditStatus;

  /**
   * 稽核备注
   */
  private String auditRemark;

  /**
   * 付款状态
   */
  private String payStatus;

  /**
   * 单据完成时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime completeTime;

  /**
   * 单据购销类型
   */
  private String settlementType;

  /**
   * 单证异常
   */
  private String ticketException;

  /**
   * 单证预警
   */
  private String ticketWarning;

  /**
   * 扩展字段1
   */
  private String ext1;

  /**
   * 扩展字段2
   */
  private String ext2;

  /**
   * 扩展字段3
   */
  private String ext3;

  /**
   * 扩展字段4
   */
  private String ext4;

  /**
   * 扩展字段5
   */
  private String ext5;

  /**
   * 扩展字段6
   */
  private String ext6;

  /**
   * 扩展字段7
   */
  private String ext7;

  /**
   * 扩展字段8
   */
  private String ext8;

  /**
   * 扩展字段9
   */
  private String ext9;

  /**
   * 扩展字段10
   */
  private String ext10;

  /**
   * 主单据状态
   */
  private String mainBillDataStatus;

  /**
   * 稽核时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime auditTime;

  /**
   * 收单状态
   */
  private String receiveStatus;

  /**
   * 是否已触发稽核
   */
  private Boolean compareTriggered;

  /**
   * 电票数量
   */
  private Long electricCount;

  /**
   * 纸票数量
   */
  private Long paperCount;

  /**
   * 提交备注
   */
  private String commitRemark;

  /**
   * 稽核人id
   */
  private Long auditUserId;

  /**
   * 稽核人姓名
   */
  private String auditUserName;

  /**
   * 提单人邮箱
   */
  private String billCreateEmail;

  /**
   * 单据异常类型
   */
  private String exceptionKey;

  /**
   * 单据异常明细
   */
  private String exceptionDetail;

  /**
   * 单据预警类型
   */
  private String warningKey;

  /**
   * 单据预警明细
   */
  private String warningDetail;

  /**
   * 普票含税总额
   */
  private BigDecimal normalAmountWithTax;

  /**
   * 专票含税总额
   */
  private BigDecimal specialAmountWithTax;

  /**
   * 专票总税额
   */
  private BigDecimal specialTaxAmount;

  /**
   * 协同普票含税总额
   */
  private BigDecimal coopNormalAmountWithTax;

  /**
   * 协同专票含税总额
   */
  private BigDecimal coopSpecialAmountWithTax;

  /**
   * 协同专票总税额
   */
  private BigDecimal coopSpecialTaxAmount;

  /**
   * 退扫标记
   */
  private String backFlag;

  /**
   * 购方租户代码
   */
  private String purchaserTenantCode;

  /**
   * 购方租户ID
   */
  private Long purchaserTenantId;

  /**
   * 是否离职员工
   */
  private String isResignedEmployee;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 image
   */
    private Long billOTOImageId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("image_id", imageId);
      map.put("batch_no", batchNo);
      map.put("bill_type_code", billTypeCode);
      map.put("bill_code", billCode);
      map.put("bill_amount_with_tax", billAmountWithTax);
      map.put("bill_tax_amount", billTaxAmount);
      map.put("bill_amount_without_tax", billAmountWithoutTax);
      map.put("bill_create_user", billCreateUser);
      map.put("bill_create_time", BocpGenUtils.toTimestamp(billCreateTime));
      map.put("scan_user_id", scanUserId);
      map.put("scan_user_name", scanUserName);
      map.put("scan_create_time", BocpGenUtils.toTimestamp(scanCreateTime));
      map.put("package_code", packageCode);
      map.put("logistics_status", logisticsStatus);
      map.put("logistics_time", BocpGenUtils.toTimestamp(logisticsTime));
      map.put("sign_status", signStatus);
      map.put("sign_time", BocpGenUtils.toTimestamp(signTime));
      map.put("is_public", isPublic);
      map.put("logistic_remark", logisticRemark);
      map.put("hang_type", hangType);
      map.put("hang_reason", hangReason);
      map.put("back_type", backType);
      map.put("back_reason", backReason);
      map.put("bill_data_status", billDataStatus);
      map.put("bill_data_time", BocpGenUtils.toTimestamp(billDataTime));
      map.put("verify_status", verifyStatus);
      map.put("verify_time", BocpGenUtils.toTimestamp(verifyTime));
      map.put("ticket_count", ticketCount);
      map.put("image_count", imageCount);
      map.put("exception_count", exceptionCount);
      map.put("warning_count", warningCount);
      map.put("is_exception", isException);
      map.put("exception_info", exceptionInfo);
      map.put("system_orig", systemOrig);
      map.put("is_secret", isSecret);
      map.put("back_remark", backRemark);
      map.put("unquality_type", unqualityType);
      map.put("unquality_reason", unqualityReason);
      map.put("verify_hang_type", verifyHangType);
      map.put("verify_hang_reason", verifyHangReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("is_prepayment", isPrepayment);
      map.put("ext_fields", extFields);
      map.put("ext_status", extStatus);
      map.put("prepayment_status", prepaymentStatus);
      map.put("prepayment_time", BocpGenUtils.toTimestamp(prepaymentTime));
      map.put("create_user_code", createUserCode);
      map.put("seller_tax_no", sellerTaxNo);
      map.put("seller_name", sellerName);
      map.put("purchaser_tax_no", purchaserTaxNo);
      map.put("purchaser_name", purchaserName);
      map.put("serial_number", serialNumber);
      map.put("bill_check_status", billCheckStatus);
      map.put("purchaser_code", purchaserCode);
      map.put("bill_check_time", BocpGenUtils.toTimestamp(billCheckTime));
      map.put("remark", remark);
      map.put("seller_code", sellerCode);
      map.put("tenant_code", tenantCode);
      map.put("back_orig", backOrig);
      map.put("calculate_status", calculateStatus);
      map.put("is_warning", isWarning);
      map.put("warning_info", warningInfo);
      map.put("purchaser_no", purchaserNo);
      map.put("back_user", backUser);
      map.put("reserved1", reserved1);
      map.put("reserved2", reserved2);
      map.put("reserved3", reserved3);
      map.put("is_commit", isCommit);
      map.put("commit_user_id", commitUserId);
      map.put("commit_user_name", commitUserName);
      map.put("commit_time", BocpGenUtils.toTimestamp(commitTime));
      map.put("upload_status", uploadStatus);
      map.put("org_id", orgId);
      map.put("org_name", orgName);
      map.put("org_code", orgCode);
      map.put("is_push_bill", isPushBill);
      map.put("is_cover", isCover);
      map.put("system_source", systemSource);
      map.put("is_add", isAdd);
      map.put("is_change", isChange);
      map.put("business_type", businessType);
      map.put("settlement_no", settlementNo);
      map.put("bill_use", billUse);
      map.put("system_orig_external", systemOrigExternal);
      map.put("compare_status", compareStatus);
      map.put("audit_status", auditStatus);
      map.put("audit_remark", auditRemark);
      map.put("pay_status", payStatus);
      map.put("complete_time", BocpGenUtils.toTimestamp(completeTime));
      map.put("settlement_type", settlementType);
      map.put("ticket_exception", ticketException);
      map.put("ticket_warning", ticketWarning);
      map.put("ext1", ext1);
      map.put("ext2", ext2);
      map.put("ext3", ext3);
      map.put("ext4", ext4);
      map.put("ext5", ext5);
      map.put("ext6", ext6);
      map.put("ext7", ext7);
      map.put("ext8", ext8);
      map.put("ext9", ext9);
      map.put("ext10", ext10);
      map.put("main_bill_data_status", mainBillDataStatus);
      map.put("audit_time", BocpGenUtils.toTimestamp(auditTime));
      map.put("receive_status", receiveStatus);
      map.put("compare_triggered", compareTriggered);
      map.put("electric_count", electricCount);
      map.put("paper_count", paperCount);
      map.put("commit_remark", commitRemark);
      map.put("audit_user_id", auditUserId);
      map.put("audit_user_name", auditUserName);
      map.put("bill_create_email", billCreateEmail);
      map.put("exception_key", exceptionKey);
      map.put("exception_detail", exceptionDetail);
      map.put("warning_key", warningKey);
      map.put("warning_detail", warningDetail);
      map.put("normal_amount_with_tax", normalAmountWithTax);
      map.put("special_amount_with_tax", specialAmountWithTax);
      map.put("special_tax_amount", specialTaxAmount);
      map.put("coop_normal_amount_with_tax", coopNormalAmountWithTax);
      map.put("coop_special_amount_with_tax", coopSpecialAmountWithTax);
      map.put("coop_special_tax_amount", coopSpecialTaxAmount);
      map.put("back_flag", backFlag);
      map.put("purchaser_tenant_code", purchaserTenantCode);
      map.put("purchaser_tenant_id", purchaserTenantId);
      map.put("is_resigned_employee", isResignedEmployee);
      map.put("org_tree", orgTree);

       map.put("billOTOImage.id", billOTOImageId);
      return map;
  }

  public static BaseBill fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BaseBill entity = new BaseBill();
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setImageId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillTypeCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_amount_with_tax")) {
      Object obj = map.get("bill_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_tax_amount")) {
      Object obj = map.get("bill_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_amount_without_tax")) {
      Object obj = map.get("bill_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCreateUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCreateTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setScanUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("scan_create_time")) {
      Object obj = map.get("scan_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setScanCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setScanCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setScanCreateTime(null);
      }
    }
    if(map.containsKey("package_code")) {
      Object obj = map.get("package_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_status")) {
      Object obj = map.get("logistics_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticsStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistics_time")) {
      Object obj = map.get("logistics_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLogisticsTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLogisticsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLogisticsTime(null);
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSignStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSignTime(null);
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPublic((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLogisticRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_type")) {
      Object obj = map.get("hang_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hang_reason")) {
      Object obj = map.get("hang_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_data_status")) {
      Object obj = map.get("bill_data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_data_time")) {
      Object obj = map.get("bill_data_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillDataTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillDataTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillDataTime(null);
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setVerifyTime(null);
      }
    }
    if(map.containsKey("ticket_count")) {
      Object obj = map.get("ticket_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTicketCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTicketCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setImageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setImageCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("exception_count")) {
      Object obj = map.get("exception_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptionCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExceptionCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExceptionCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("warning_count")) {
      Object obj = map.get("warning_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setWarningCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setWarningCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setWarningCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_exception")) {
      Object obj = map.get("is_exception");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_secret")) {
      Object obj = map.get("is_secret");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSecret((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unquality_type")) {
      Object obj = map.get("unquality_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualityType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unquality_reason")) {
      Object obj = map.get("unquality_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnqualityReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_hang_type")) {
      Object obj = map.get("verify_hang_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyHangType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verify_hang_reason")) {
      Object obj = map.get("verify_hang_reason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVerifyHangReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_prepayment")) {
      Object obj = map.get("is_prepayment");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPrepayment((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtFields((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext_status")) {
      Object obj = map.get("ext_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPrepaymentStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("prepayment_time")) {
      Object obj = map.get("prepayment_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPrepaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrepaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPrepaymentTime(null);
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSerialNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_check_status")) {
      Object obj = map.get("bill_check_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_check_time")) {
      Object obj = map.get("bill_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBillCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBillCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBillCheckTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_orig")) {
      Object obj = map.get("back_orig");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackOrig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCalculateStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_warning")) {
      Object obj = map.get("is_warning");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsWarning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackUser((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReserved3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCommit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommitUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCommitTime(null);
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUploadStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrgId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_push_bill")) {
      Object obj = map.get("is_push_bill");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsPushBill((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsCover((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsAdd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_use")) {
      Object obj = map.get("bill_use");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillUse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("system_orig_external")) {
      Object obj = map.get("system_orig_external");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSystemOrigExternal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCompareStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPayStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCompleteTime(null);
      }
    }
    if(map.containsKey("settlement_type")) {
      Object obj = map.get("settlement_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSettlementType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_exception")) {
      Object obj = map.get("ticket_exception");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketException((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_warning")) {
      Object obj = map.get("ticket_warning");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketWarning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExt10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("main_bill_data_status")) {
      Object obj = map.get("main_bill_data_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMainBillDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAuditTime(null);
      }
    }
    if(map.containsKey("receive_status")) {
      Object obj = map.get("receive_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("compare_triggered")) {
      Object obj = map.get("compare_triggered");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setCompareTriggered((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCompareTriggered(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("electric_count")) {
      Object obj = map.get("electric_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setElectricCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setElectricCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setElectricCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("paper_count")) {
      Object obj = map.get("paper_count");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaperCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPaperCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaperCount(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("commit_remark")) {
      Object obj = map.get("commit_remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCommitRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("audit_user_id")) {
      Object obj = map.get("audit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAuditUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAuditUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAuditUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("audit_user_name")) {
      Object obj = map.get("audit_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAuditUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bill_create_email")) {
      Object obj = map.get("bill_create_email");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBillCreateEmail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_key")) {
      Object obj = map.get("exception_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exception_detail")) {
      Object obj = map.get("exception_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExceptionDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_key")) {
      Object obj = map.get("warning_key");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningKey((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warning_detail")) {
      Object obj = map.get("warning_detail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarningDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("normal_amount_with_tax")) {
      Object obj = map.get("normal_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNormalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNormalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNormalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNormalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNormalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("special_amount_with_tax")) {
      Object obj = map.get("special_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecialAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecialAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecialAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecialAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecialAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("special_tax_amount")) {
      Object obj = map.get("special_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSpecialTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSpecialTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSpecialTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSpecialTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSpecialTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coop_normal_amount_with_tax")) {
      Object obj = map.get("coop_normal_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCoopNormalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCoopNormalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCoopNormalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCoopNormalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCoopNormalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coop_special_amount_with_tax")) {
      Object obj = map.get("coop_special_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCoopSpecialAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCoopSpecialAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCoopSpecialAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCoopSpecialAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCoopSpecialAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coop_special_tax_amount")) {
      Object obj = map.get("coop_special_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCoopSpecialTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCoopSpecialTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCoopSpecialTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCoopSpecialTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCoopSpecialTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("back_flag")) {
      Object obj = map.get("back_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBackFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_code")) {
      Object obj = map.get("purchaser_tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("is_resigned_employee")) {
      Object obj = map.get("is_resigned_employee");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsResignedEmployee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("billOTOImage.id")) {
        Object obj = map.get("billOTOImage.id");
      if(obj instanceof Long) {
        entity.setBillOTOImageId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setBillOTOImageId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("image_id")) {
      Object obj = map.get("image_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setImageId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setImageId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("batch_no")) {
      Object obj = map.get("batch_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_type_code")) {
      Object obj = map.get("bill_type_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillTypeCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_code")) {
      Object obj = map.get("bill_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_amount_with_tax")) {
      Object obj = map.get("bill_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_tax_amount")) {
      Object obj = map.get("bill_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_amount_without_tax")) {
      Object obj = map.get("bill_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBillAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBillAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bill_create_user")) {
      Object obj = map.get("bill_create_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCreateUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_create_time")) {
      Object obj = map.get("bill_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillCreateTime(null);
      }
    }
    if(map.containsKey("scan_user_id")) {
      Object obj = map.get("scan_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setScanUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setScanUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setScanUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("scan_user_name")) {
      Object obj = map.get("scan_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setScanUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("scan_create_time")) {
      Object obj = map.get("scan_create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setScanCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setScanCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setScanCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setScanCreateTime(null);
      }
    }
    if(map.containsKey("package_code")) {
      Object obj = map.get("package_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_status")) {
      Object obj = map.get("logistics_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistics_time")) {
      Object obj = map.get("logistics_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLogisticsTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLogisticsTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLogisticsTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLogisticsTime(null);
      }
    }
    if(map.containsKey("sign_status")) {
      Object obj = map.get("sign_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSignStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sign_time")) {
      Object obj = map.get("sign_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSignTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSignTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSignTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSignTime(null);
      }
    }
    if(map.containsKey("is_public")) {
      Object obj = map.get("is_public");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsPublic((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("logistic_remark")) {
      Object obj = map.get("logistic_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_type")) {
      Object obj = map.get("hang_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hang_reason")) {
      Object obj = map.get("hang_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_type")) {
      Object obj = map.get("back_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_reason")) {
      Object obj = map.get("back_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_data_status")) {
      Object obj = map.get("bill_data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_data_time")) {
      Object obj = map.get("bill_data_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillDataTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillDataTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillDataTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillDataTime(null);
      }
    }
    if(map.containsKey("verify_status")) {
      Object obj = map.get("verify_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_time")) {
      Object obj = map.get("verify_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setVerifyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setVerifyTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVerifyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setVerifyTime(null);
      }
    }
    if(map.containsKey("ticket_count")) {
      Object obj = map.get("ticket_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTicketCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTicketCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTicketCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("image_count")) {
      Object obj = map.get("image_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setImageCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setImageCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setImageCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("exception_count")) {
      Object obj = map.get("exception_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptionCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExceptionCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExceptionCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("warning_count")) {
      Object obj = map.get("warning_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setWarningCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setWarningCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setWarningCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_exception")) {
      Object obj = map.get("is_exception");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_info")) {
      Object obj = map.get("exception_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig")) {
      Object obj = map.get("system_orig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_secret")) {
      Object obj = map.get("is_secret");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSecret((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_remark")) {
      Object obj = map.get("back_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unquality_type")) {
      Object obj = map.get("unquality_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualityType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unquality_reason")) {
      Object obj = map.get("unquality_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnqualityReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_hang_type")) {
      Object obj = map.get("verify_hang_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyHangType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("verify_hang_reason")) {
      Object obj = map.get("verify_hang_reason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVerifyHangReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_prepayment")) {
      Object obj = map.get("is_prepayment");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsPrepayment((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_fields")) {
      Object obj = map.get("ext_fields");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtFields((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext_status")) {
      Object obj = map.get("ext_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepayment_status")) {
      Object obj = map.get("prepayment_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPrepaymentStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("prepayment_time")) {
      Object obj = map.get("prepayment_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPrepaymentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPrepaymentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrepaymentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPrepaymentTime(null);
      }
    }
    if(map.containsKey("create_user_code")) {
      Object obj = map.get("create_user_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_tax_no")) {
      Object obj = map.get("seller_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tax_no")) {
      Object obj = map.get("purchaser_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_name")) {
      Object obj = map.get("purchaser_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("serial_number")) {
      Object obj = map.get("serial_number");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSerialNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_check_status")) {
      Object obj = map.get("bill_check_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_code")) {
      Object obj = map.get("purchaser_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_check_time")) {
      Object obj = map.get("bill_check_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBillCheckTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBillCheckTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillCheckTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBillCheckTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_orig")) {
      Object obj = map.get("back_orig");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackOrig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("calculate_status")) {
      Object obj = map.get("calculate_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCalculateStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_warning")) {
      Object obj = map.get("is_warning");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsWarning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_info")) {
      Object obj = map.get("warning_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarningInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_no")) {
      Object obj = map.get("purchaser_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("back_user")) {
      Object obj = map.get("back_user");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackUser((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved1")) {
      Object obj = map.get("reserved1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved2")) {
      Object obj = map.get("reserved2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reserved3")) {
      Object obj = map.get("reserved3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReserved3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_commit")) {
      Object obj = map.get("is_commit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCommit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_id")) {
      Object obj = map.get("commit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCommitUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCommitUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCommitUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("commit_user_name")) {
      Object obj = map.get("commit_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCommitUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commit_time")) {
      Object obj = map.get("commit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCommitTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCommitTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCommitTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCommitTime(null);
      }
    }
    if(map.containsKey("upload_status")) {
      Object obj = map.get("upload_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUploadStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_id")) {
      Object obj = map.get("org_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrgId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrgId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrgId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_name")) {
      Object obj = map.get("org_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_code")) {
      Object obj = map.get("org_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_push_bill")) {
      Object obj = map.get("is_push_bill");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsPushBill((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_cover")) {
      Object obj = map.get("is_cover");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsCover((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_source")) {
      Object obj = map.get("system_source");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_add")) {
      Object obj = map.get("is_add");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsAdd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("is_change")) {
      Object obj = map.get("is_change");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsChange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("settlement_no")) {
      Object obj = map.get("settlement_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_use")) {
      Object obj = map.get("bill_use");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillUse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("system_orig_external")) {
      Object obj = map.get("system_orig_external");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSystemOrigExternal((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compare_status")) {
      Object obj = map.get("compare_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompareStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_status")) {
      Object obj = map.get("audit_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_remark")) {
      Object obj = map.get("audit_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_status")) {
      Object obj = map.get("pay_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("complete_time")) {
      Object obj = map.get("complete_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCompleteTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCompleteTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompleteTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCompleteTime(null);
      }
    }
    if(map.containsKey("settlement_type")) {
      Object obj = map.get("settlement_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_exception")) {
      Object obj = map.get("ticket_exception");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketException((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_warning")) {
      Object obj = map.get("ticket_warning");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketWarning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext1")) {
      Object obj = map.get("ext1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext2")) {
      Object obj = map.get("ext2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext3")) {
      Object obj = map.get("ext3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext4")) {
      Object obj = map.get("ext4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext5")) {
      Object obj = map.get("ext5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext6")) {
      Object obj = map.get("ext6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext7")) {
      Object obj = map.get("ext7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext8")) {
      Object obj = map.get("ext8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext9")) {
      Object obj = map.get("ext9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ext10")) {
      Object obj = map.get("ext10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExt10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("main_bill_data_status")) {
      Object obj = map.get("main_bill_data_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMainBillDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_time")) {
      Object obj = map.get("audit_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAuditTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAuditTime(null);
      }
    }
    if(map.containsKey("receive_status")) {
      Object obj = map.get("receive_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("compare_triggered")) {
      Object obj = map.get("compare_triggered");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setCompareTriggered((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCompareTriggered(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("electric_count")) {
      Object obj = map.get("electric_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setElectricCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setElectricCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setElectricCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("paper_count")) {
      Object obj = map.get("paper_count");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaperCount((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPaperCount(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaperCount(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("commit_remark")) {
      Object obj = map.get("commit_remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCommitRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("audit_user_id")) {
      Object obj = map.get("audit_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAuditUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAuditUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAuditUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("audit_user_name")) {
      Object obj = map.get("audit_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAuditUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bill_create_email")) {
      Object obj = map.get("bill_create_email");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillCreateEmail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_key")) {
      Object obj = map.get("exception_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exception_detail")) {
      Object obj = map.get("exception_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExceptionDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_key")) {
      Object obj = map.get("warning_key");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarningKey((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warning_detail")) {
      Object obj = map.get("warning_detail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarningDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("normal_amount_with_tax")) {
      Object obj = map.get("normal_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNormalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNormalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNormalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNormalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNormalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("special_amount_with_tax")) {
      Object obj = map.get("special_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSpecialAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSpecialAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSpecialAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpecialAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpecialAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("special_tax_amount")) {
      Object obj = map.get("special_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSpecialTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSpecialTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSpecialTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSpecialTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSpecialTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coop_normal_amount_with_tax")) {
      Object obj = map.get("coop_normal_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCoopNormalAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCoopNormalAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCoopNormalAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCoopNormalAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCoopNormalAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coop_special_amount_with_tax")) {
      Object obj = map.get("coop_special_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCoopSpecialAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCoopSpecialAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCoopSpecialAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCoopSpecialAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCoopSpecialAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coop_special_tax_amount")) {
      Object obj = map.get("coop_special_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCoopSpecialTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCoopSpecialTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCoopSpecialTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCoopSpecialTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCoopSpecialTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("back_flag")) {
      Object obj = map.get("back_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBackFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tenant_code")) {
      Object obj = map.get("purchaser_tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaser_tenant_id")) {
      Object obj = map.get("purchaser_tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPurchaserTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaserTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaserTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("is_resigned_employee")) {
      Object obj = map.get("is_resigned_employee");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsResignedEmployee((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("billOTOImage.id")) {
        Object obj = map.get("billOTOImage.id");
        if(obj instanceof Long) {
          this.setBillOTOImageId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBillOTOImageId(Long.parseLong((String)obj));
        }
      }
  }
}
