package com.xforceplus.ultraman.app.imageservicesaas.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicket;

/**
 * <p>
 * 数据比对用途的火车票
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class CompareTicketTrain extends CompareTicket {


  /**
   * 姓名
   */
  private String name;

  /**
   * 车次
   */
  private String trains;

  /**
   * 出发站
   */
  private String startStation;

  /**
   * 目的站
   */
  private String endStation;

  /**
   * 出发日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime startDate;

  /**
   * 出发时间
   */
  private String startTime;

  /**
   * 座位号
   */
  private String seat;

  /**
   * 座位类型
   */
  private String seatType;

  /**
   * 凭证号
   */
  private String certificateNo;

  /**
   * 开票日期
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime dateOfIssue;

  /**
   * 开票单位
   */
  private String issuedBy;

  /**
   * 开票单位代码
   */
  private String issuedByCode;

  /**
   * 车厢（旧）
   */
  private String carriage;

  /**
   * 优惠标识
   */
  private String preferential;

  /**
   * 支付金额
   */
  private BigDecimal payAmount;

  /**
   * 已退金额
   */
  private BigDecimal backAmount;

  /**
   * 原票票价
   */
  private BigDecimal originAmountWithTax;

  /**
   * 原票出发站
   */
  private String originStartStation;

  /**
   * 原票到达站
   */
  private String originEndStation;

  /**
   * 电子客票号
   */
  private String eTicketNo;

  /**
   * 税率
   */
  private String vatTax;

  /**
   * 税额
   */
  private BigDecimal vatTaxAmount;

  /**
   * 业务类型
   */
  private String businessType;

  /**
   * 票种（旧）
   */
  private String invoiceCategory;

  /**
   * 票种
   */
  private String ticketType;

  /**
   * 空调特征
   */
  private String airConditioning;

  /**
   * 车厢
   */
  private String railwayCarriage;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("name", name);
      map.put("trains", trains);
      map.put("start_station", startStation);
      map.put("end_station", endStation);
      map.put("start_date", BocpGenUtils.toTimestamp(startDate));
      map.put("start_time", startTime);
      map.put("seat", seat);
      map.put("seat_type", seatType);
      map.put("certificate_no", certificateNo);
      map.put("date_of_issue", BocpGenUtils.toTimestamp(dateOfIssue));
      map.put("issued_by", issuedBy);
      map.put("issued_by_code", issuedByCode);
      map.put("carriage", carriage);
      map.put("preferential", preferential);
      map.put("pay_amount", payAmount);
      map.put("back_amount", backAmount);
      map.put("origin_amount_with_tax", originAmountWithTax);
      map.put("origin_start_station", originStartStation);
      map.put("origin_end_station", originEndStation);
      map.put("e_ticket_no", eTicketNo);
      map.put("vat_tax", vatTax);
      map.put("vat_tax_amount", vatTaxAmount);
      map.put("business_type", businessType);
      map.put("invoice_category", invoiceCategory);
      map.put("ticket_type", ticketType);
      map.put("air_conditioning", airConditioning);
      map.put("railway_carriage", railwayCarriage);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static CompareTicketTrain fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    CompareTicketTrain entity = new CompareTicketTrain();
    entity.setParentByOQSMap(map);
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("trains")) {
      Object obj = map.get("trains");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTrains((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_station")) {
      Object obj = map.get("start_station");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("end_station")) {
      Object obj = map.get("end_station");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEndStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStartDate(null);
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStartTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seat_type")) {
      Object obj = map.get("seat_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSeatType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("certificate_no")) {
      Object obj = map.get("certificate_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCertificateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("date_of_issue")) {
      Object obj = map.get("date_of_issue");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDateOfIssue(null);
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuedBy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("issued_by_code")) {
      Object obj = map.get("issued_by_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIssuedByCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("carriage")) {
      Object obj = map.get("carriage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCarriage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("preferential")) {
      Object obj = map.get("preferential");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreferential((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("back_amount")) {
      Object obj = map.get("back_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("origin_amount_with_tax")) {
      Object obj = map.get("origin_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("origin_start_station")) {
      Object obj = map.get("origin_start_station");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginStartStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("origin_end_station")) {
      Object obj = map.get("origin_end_station");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOriginEndStation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("e_ticket_no")) {
      Object obj = map.get("e_ticket_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setETicketNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vat_tax")) {
      Object obj = map.get("vat_tax");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVatTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vat_tax_amount")) {
      Object obj = map.get("vat_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVatTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVatTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVatTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setVatTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVatTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_type")) {
      Object obj = map.get("ticket_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTicketType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("air_conditioning")) {
      Object obj = map.get("air_conditioning");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAirConditioning((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("railway_carriage")) {
      Object obj = map.get("railway_carriage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRailwayCarriage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("name")) {
      Object obj = map.get("name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("trains")) {
      Object obj = map.get("trains");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTrains((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_station")) {
      Object obj = map.get("start_station");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartStation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("end_station")) {
      Object obj = map.get("end_station");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEndStation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("start_date")) {
      Object obj = map.get("start_date");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStartDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStartDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStartDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStartDate(null);
      }
    }
    if(map.containsKey("start_time")) {
      Object obj = map.get("start_time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStartTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seat")) {
      Object obj = map.get("seat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seat_type")) {
      Object obj = map.get("seat_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSeatType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("certificate_no")) {
      Object obj = map.get("certificate_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCertificateNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("date_of_issue")) {
      Object obj = map.get("date_of_issue");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDateOfIssue(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDateOfIssue((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDateOfIssue(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDateOfIssue(null);
      }
    }
    if(map.containsKey("issued_by")) {
      Object obj = map.get("issued_by");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuedBy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("issued_by_code")) {
      Object obj = map.get("issued_by_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIssuedByCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("carriage")) {
      Object obj = map.get("carriage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCarriage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("preferential")) {
      Object obj = map.get("preferential");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreferential((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pay_amount")) {
      Object obj = map.get("pay_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("back_amount")) {
      Object obj = map.get("back_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBackAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBackAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBackAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBackAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBackAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("origin_amount_with_tax")) {
      Object obj = map.get("origin_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("origin_start_station")) {
      Object obj = map.get("origin_start_station");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginStartStation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("origin_end_station")) {
      Object obj = map.get("origin_end_station");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginEndStation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("e_ticket_no")) {
      Object obj = map.get("e_ticket_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setETicketNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vat_tax")) {
      Object obj = map.get("vat_tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVatTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vat_tax_amount")) {
      Object obj = map.get("vat_tax_amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setVatTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setVatTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setVatTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setVatTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setVatTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("business_type")) {
      Object obj = map.get("business_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoice_category")) {
      Object obj = map.get("invoice_category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_type")) {
      Object obj = map.get("ticket_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTicketType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("air_conditioning")) {
      Object obj = map.get("air_conditioning");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAirConditioning((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("railway_carriage")) {
      Object obj = map.get("railway_carriage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRailwayCarriage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
