package com.xforceplus.ultraman.app.imageservicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketHaiwaifapiaozhuxinxiDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 编号
   */
  private String itemId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 名称
   */
  private String itemName;

  /**
   * 单价
   */
  private String itemUnitPrice;

  /**
   * 数量
   */
  private String itemQuantity;

  /**
   * 金额
   */
  private String itemSubtotalAmount;

  /**
   * 合同Id
   */
  @TableField("contractId")
  private String contractId;

  /**
   * 是否享受减免税率
   */
  private String jianmian;

  /**
   * 交易日期
   */
  private String jiaoyiDate;

  /**
   * 单证主ID
   */
  private Long ticketId;

  /**
   * 不含税金额
   */
  private String buhanshuizongAmountDgjyd;

  /**
   * 税额
   */
  private String itemTaxAmount;

  /**
   * 税率
   */
  private String taxRate;

  /**
   * 识别率
   */
  private String ocrRate;

  /**
   * 识别完成时间
   */
  private String ocrFinish;

  /**
   * 识别耗时
   */
  private String ocrDuration;

  /**
   * 扩展字段1
   */
  private String haiwaiext1;

  /**
   * 扩展字段2
   */
  private String haiwaiext2;

  /**
   * 扩展字段3
   */
  private String haiwaiext3;

  /**
   * 扩展字段4
   */
  private String haiwaiext4;

  /**
   * 扩展字段5
   */
  private String haiwaiext5;

  /**
   * 扩展字段6
   */
  private String haiwaiext6;

  /**
   * 扩展字段7
   */
  private String haiwaiext7;

  /**
   * 扩展字段8
   */
  private String haiwaiext8;

  /**
   * 扩展字段9
   */
  private String haiwaiext9;

  /**
   * 扩展字段10
   */
  private String haiwaiext10;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 ticketHaiwaifapiaozhuxinxi
   */
    private Long itemsId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("item_id", itemId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("item_name", itemName);
      map.put("item_unit_price", itemUnitPrice);
      map.put("item_quantity", itemQuantity);
      map.put("item_subtotal_amount", itemSubtotalAmount);
      map.put("contractId", contractId);
      map.put("jianmian", jianmian);
      map.put("jiaoyi_date", jiaoyiDate);
      map.put("ticket_id", ticketId);
      map.put("buhanshuizong_amount_dgjyd", buhanshuizongAmountDgjyd);
      map.put("item_tax_amount", itemTaxAmount);
      map.put("tax_rate", taxRate);
      map.put("ocr_rate", ocrRate);
      map.put("ocr_finish", ocrFinish);
      map.put("ocr_duration", ocrDuration);
      map.put("haiwaiext_1", haiwaiext1);
      map.put("haiwaiext_2", haiwaiext2);
      map.put("haiwaiext_3", haiwaiext3);
      map.put("haiwaiext_4", haiwaiext4);
      map.put("haiwaiext_5", haiwaiext5);
      map.put("haiwaiext_6", haiwaiext6);
      map.put("haiwaiext_7", haiwaiext7);
      map.put("haiwaiext_8", haiwaiext8);
      map.put("haiwaiext_9", haiwaiext9);
      map.put("haiwaiext_10", haiwaiext10);
      map.put("org_tree", orgTree);

       map.put("items.id", itemsId);
      return map;
  }

  public static TicketHaiwaifapiaozhuxinxiDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketHaiwaifapiaozhuxinxiDetail entity = new TicketHaiwaifapiaozhuxinxiDetail();
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_unit_price")) {
      Object obj = map.get("item_unit_price");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemUnitPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_quantity")) {
      Object obj = map.get("item_quantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_subtotal_amount")) {
      Object obj = map.get("item_subtotal_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubtotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jianmian")) {
      Object obj = map.get("jianmian");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJianmian((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiaoyi_date")) {
      Object obj = map.get("jiaoyi_date");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiaoyiDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ticket_id")) {
      Object obj = map.get("ticket_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTicketId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTicketId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTicketId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("buhanshuizong_amount_dgjyd")) {
      Object obj = map.get("buhanshuizong_amount_dgjyd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuhanshuizongAmountDgjyd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_tax_amount")) {
      Object obj = map.get("item_tax_amount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemTaxAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaxRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrFinish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_6")) {
      Object obj = map.get("haiwaiext_6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_7")) {
      Object obj = map.get("haiwaiext_7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_8")) {
      Object obj = map.get("haiwaiext_8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_9")) {
      Object obj = map.get("haiwaiext_9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_10")) {
      Object obj = map.get("haiwaiext_10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("items.id")) {
        Object obj = map.get("items.id");
      if(obj instanceof Long) {
        entity.setItemsId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setItemsId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("item_id")) {
      Object obj = map.get("item_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_name")) {
      Object obj = map.get("item_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_unit_price")) {
      Object obj = map.get("item_unit_price");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemUnitPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_quantity")) {
      Object obj = map.get("item_quantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_subtotal_amount")) {
      Object obj = map.get("item_subtotal_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubtotalAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractId")) {
      Object obj = map.get("contractId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jianmian")) {
      Object obj = map.get("jianmian");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJianmian((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiaoyi_date")) {
      Object obj = map.get("jiaoyi_date");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiaoyiDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ticket_id")) {
      Object obj = map.get("ticket_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTicketId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTicketId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTicketId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("buhanshuizong_amount_dgjyd")) {
      Object obj = map.get("buhanshuizong_amount_dgjyd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuhanshuizongAmountDgjyd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_tax_amount")) {
      Object obj = map.get("item_tax_amount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemTaxAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrFinish((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrDuration((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_6")) {
      Object obj = map.get("haiwaiext_6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_7")) {
      Object obj = map.get("haiwaiext_7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_8")) {
      Object obj = map.get("haiwaiext_8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_9")) {
      Object obj = map.get("haiwaiext_9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_10")) {
      Object obj = map.get("haiwaiext_10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("items.id")) {
        Object obj = map.get("items.id");
        if(obj instanceof Long) {
          this.setItemsId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setItemsId(Long.parseLong((String)obj));
        }
      }
  }
}
