package com.xforceplus.ultraman.app.imageservicesaas.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.app.imageservicesaas.entity.Ticket;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-10-27
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class TicketJpguanwangxingchengdan extends Ticket {


  /**
   * 航空公司名称
   */
  private String hangkonggongsiNameGw;

  /**
   * 乘机人姓名
   */
  private String chengjirenNameGw;

  /**
   * 航班号
   */
  private String hangbanNoGw;

  /**
   * 起飞机场
   */
  private String qifeijiGroundGw;

  /**
   * 降落机场
   */
  private String jiangluojiGroundGw;

  /**
   * 舱位等级
   */
  private String cangweidengLevelGw;

  /**
   * 座位号
   */
  private String zuofeiNoGw;

  /**
   * 机票号码
   */
  private String jipiaoNoGw;

  /**
   * 支付方式
   */
  private String zhifufangMethodGw;

  /**
   * 国家
   */
  private String country;

  /**
   * IATA番号
   */
  private String iatafanNoDsf;

  /**
   * 预定确认编码
   */
  private String yudingquerenCodeDsf;

  /**
   * 子类型
   */
  private String xingchengdanZileixing;

  /**
   * 飞行日期
   */
  private String feixingDateGw;

  /**
   * 不含税金额
   */
  private String buhanshuiAmountGw;

  /**
   * 含税总价
   */
  private String hanzuizongAmountGw;

  /**
   * 识别率
   */
  private String ocrRate;

  /**
   * 识别完成时间
   */
  private String ocrFinish;

  /**
   * 识别耗时
   */
  private String ocrDuration;

  /**
   * 扩展字段1
   */
  private String haiwaiext1;

  /**
   * 扩展字段2
   */
  private String haiwaiext2;

  /**
   * 扩展字段3
   */
  private String haiwaiext3;

  /**
   * 扩展字段4
   */
  private String haiwaiext4;

  /**
   * 扩展字段5
   */
  private String haiwaiext5;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 组织树
   */
  private String orgTree;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.putAll(super.toOQSMap());
      map.put("hangkonggongsi_name_gw", hangkonggongsiNameGw);
      map.put("chengjiren_name_gw", chengjirenNameGw);
      map.put("hangban_no_gw", hangbanNoGw);
      map.put("qifeiji_ground_gw", qifeijiGroundGw);
      map.put("jiangluoji_ground_gw", jiangluojiGroundGw);
      map.put("cangweideng_level_gw", cangweidengLevelGw);
      map.put("zuofei_no_gw", zuofeiNoGw);
      map.put("jipiao_no_gw", jipiaoNoGw);
      map.put("zhifufang_method_gw", zhifufangMethodGw);
      map.put("country", country);
      map.put("iatafan_no_dsf", iatafanNoDsf);
      map.put("yudingqueren_code_dsf", yudingquerenCodeDsf);
      map.put("xingchengdan_zileixing", xingchengdanZileixing);
      map.put("feixing_date_gw", feixingDateGw);
      map.put("buhanshui_amount_gw", buhanshuiAmountGw);
      map.put("hanzuizong_amount_gw", hanzuizongAmountGw);
      map.put("ocr_rate", ocrRate);
      map.put("ocr_finish", ocrFinish);
      map.put("ocr_duration", ocrDuration);
      map.put("haiwaiext_1", haiwaiext1);
      map.put("haiwaiext_2", haiwaiext2);
      map.put("haiwaiext_3", haiwaiext3);
      map.put("haiwaiext_4", haiwaiext4);
      map.put("haiwaiext_5", haiwaiext5);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("org_tree", orgTree);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static TicketJpguanwangxingchengdan fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    TicketJpguanwangxingchengdan entity = new TicketJpguanwangxingchengdan();
    entity.setParentByOQSMap(map);
    if(map.containsKey("hangkonggongsi_name_gw")) {
      Object obj = map.get("hangkonggongsi_name_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangkonggongsiNameGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chengjiren_name_gw")) {
      Object obj = map.get("chengjiren_name_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChengjirenNameGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hangban_no_gw")) {
      Object obj = map.get("hangban_no_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHangbanNoGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qifeiji_ground_gw")) {
      Object obj = map.get("qifeiji_ground_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setQifeijiGroundGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jiangluoji_ground_gw")) {
      Object obj = map.get("jiangluoji_ground_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJiangluojiGroundGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cangweideng_level_gw")) {
      Object obj = map.get("cangweideng_level_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCangweidengLevelGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zuofei_no_gw")) {
      Object obj = map.get("zuofei_no_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZuofeiNoGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jipiao_no_gw")) {
      Object obj = map.get("jipiao_no_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJipiaoNoGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zhifufang_method_gw")) {
      Object obj = map.get("zhifufang_method_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZhifufangMethodGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCountry((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("iatafan_no_dsf")) {
      Object obj = map.get("iatafan_no_dsf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIatafanNoDsf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("yudingqueren_code_dsf")) {
      Object obj = map.get("yudingqueren_code_dsf");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYudingquerenCodeDsf((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("xingchengdan_zileixing")) {
      Object obj = map.get("xingchengdan_zileixing");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setXingchengdanZileixing((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("feixing_date_gw")) {
      Object obj = map.get("feixing_date_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFeixingDateGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buhanshui_amount_gw")) {
      Object obj = map.get("buhanshui_amount_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuhanshuiAmountGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("hanzuizong_amount_gw")) {
      Object obj = map.get("hanzuizong_amount_gw");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHanzuizongAmountGw((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrFinish((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOcrDuration((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHaiwaiext5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }

  protected void setParentByOQSMap(Map map) {
    super.setByOQSMap(map);
  }

  protected void setByOQSMap(Map map) {
    super.setByOQSMap(map);
    if(map.containsKey("hangkonggongsi_name_gw")) {
      Object obj = map.get("hangkonggongsi_name_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangkonggongsiNameGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chengjiren_name_gw")) {
      Object obj = map.get("chengjiren_name_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChengjirenNameGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hangban_no_gw")) {
      Object obj = map.get("hangban_no_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHangbanNoGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qifeiji_ground_gw")) {
      Object obj = map.get("qifeiji_ground_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setQifeijiGroundGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jiangluoji_ground_gw")) {
      Object obj = map.get("jiangluoji_ground_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJiangluojiGroundGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cangweideng_level_gw")) {
      Object obj = map.get("cangweideng_level_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCangweidengLevelGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zuofei_no_gw")) {
      Object obj = map.get("zuofei_no_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZuofeiNoGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jipiao_no_gw")) {
      Object obj = map.get("jipiao_no_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJipiaoNoGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zhifufang_method_gw")) {
      Object obj = map.get("zhifufang_method_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZhifufangMethodGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("country")) {
      Object obj = map.get("country");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCountry((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("iatafan_no_dsf")) {
      Object obj = map.get("iatafan_no_dsf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIatafanNoDsf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("yudingqueren_code_dsf")) {
      Object obj = map.get("yudingqueren_code_dsf");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYudingquerenCodeDsf((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("xingchengdan_zileixing")) {
      Object obj = map.get("xingchengdan_zileixing");
      if(obj != null) {
        if(obj instanceof String) {
          this.setXingchengdanZileixing((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("feixing_date_gw")) {
      Object obj = map.get("feixing_date_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFeixingDateGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buhanshui_amount_gw")) {
      Object obj = map.get("buhanshui_amount_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuhanshuiAmountGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("hanzuizong_amount_gw")) {
      Object obj = map.get("hanzuizong_amount_gw");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHanzuizongAmountGw((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_rate")) {
      Object obj = map.get("ocr_rate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_finish")) {
      Object obj = map.get("ocr_finish");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrFinish((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ocr_duration")) {
      Object obj = map.get("ocr_duration");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOcrDuration((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_1")) {
      Object obj = map.get("haiwaiext_1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_2")) {
      Object obj = map.get("haiwaiext_2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_3")) {
      Object obj = map.get("haiwaiext_3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_4")) {
      Object obj = map.get("haiwaiext_4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("haiwaiext_5")) {
      Object obj = map.get("haiwaiext_5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHaiwaiext5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
