package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.BatchNumberRule;
import com.xforceplus.ultraman.app.imageservicesaas.service.IBatchNumberRuleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 批次号规则前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class BatchNumberRuleController {

  @Autowired
  private IBatchNumberRuleService batchNumberRuleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param batchNumberRule 批次号规则
   * @return
   */
  @GetMapping("/batchnumberrules" )
  public XfR getBatchNumberRules(XfPage page, BatchNumberRule batchNumberRule) {
    return XfR.ok(batchNumberRuleServiceImpl.page(page, Wrappers.query(batchNumberRule)));
  }

  /**
   * 通过id查询批次号规则
   * @param  id
   * @return XfR
   */
  @GetMapping("/batchnumberrules/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(batchNumberRuleServiceImpl.getById(id));
  }

  /**
   * 新增批次号规则
   * @param batchNumberRule 批次号规则
   * @return XfR
   */
  @PostMapping("/batchnumberrules")
  public XfR save(@RequestBody BatchNumberRule batchNumberRule) {
     return XfR.ok(batchNumberRuleServiceImpl.save(batchNumberRule));
  }

  /**
   * 修改-传入修改后的全部数据批次号规则
   * @param batchNumberRule 批次号规则
   * @return XfR
   */
  @PutMapping("/batchnumberrules/{id}")
  public XfR putUpdate(@RequestBody BatchNumberRule batchNumberRule,@PathVariable Long id) {
      batchNumberRule.setId(id);
      return XfR.ok(batchNumberRuleServiceImpl.updateById(batchNumberRule));
  }

  /**
   * 修改-传入修改的数据批次号规则
   * @param batchNumberRule 批次号规则
   * @return XfR
   */
  @PatchMapping("/batchnumberrules/{id}")
  public XfR patchUpdate(@RequestBody BatchNumberRule batchNumberRule,@PathVariable Long id) {
      BatchNumberRule upbatchNumberRule = batchNumberRuleServiceImpl.getById(id);
      if(upbatchNumberRule != null){
        upbatchNumberRule = ObjectCopyUtils.copyProperties(batchNumberRule,upbatchNumberRule,true);
      }
      return XfR.ok(batchNumberRuleServiceImpl.updateById(upbatchNumberRule));
  }

  /**
   * 通过id删除批次号规则
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/batchnumberrules/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(batchNumberRuleServiceImpl.removeById(id));
  }

  @PostMapping("/batchnumberrules/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "batch_number_rule");
     params.put("request", condition);

     return XfR.ok(batchNumberRuleServiceImpl.querys(params));
  }

}
