package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.CompareTicketImport;
import com.xforceplus.ultraman.app.imageservicesaas.service.ICompareTicketImportService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 比对进口发票前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class CompareTicketImportController {

  @Autowired
  private ICompareTicketImportService compareTicketImportServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param compareTicketImport 比对进口发票
   * @return
   */
  @GetMapping("/compareticketimports" )
  public XfR getCompareTicketImports(XfPage page, CompareTicketImport compareTicketImport) {
    return XfR.ok(compareTicketImportServiceImpl.page(page, Wrappers.query(compareTicketImport)));
  }

  /**
   * 通过id查询比对进口发票
   * @param  id
   * @return XfR
   */
  @GetMapping("/compareticketimports/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(compareTicketImportServiceImpl.getById(id));
  }

  /**
   * 新增比对进口发票
   * @param compareTicketImport 比对进口发票
   * @return XfR
   */
  @PostMapping("/compareticketimports")
  public XfR save(@RequestBody CompareTicketImport compareTicketImport) {
     return XfR.ok(compareTicketImportServiceImpl.save(compareTicketImport));
  }

  /**
   * 修改-传入修改后的全部数据比对进口发票
   * @param compareTicketImport 比对进口发票
   * @return XfR
   */
  @PutMapping("/compareticketimports/{id}")
  public XfR putUpdate(@RequestBody CompareTicketImport compareTicketImport,@PathVariable Long id) {
      compareTicketImport.setId(id);
      return XfR.ok(compareTicketImportServiceImpl.updateById(compareTicketImport));
  }

  /**
   * 修改-传入修改的数据比对进口发票
   * @param compareTicketImport 比对进口发票
   * @return XfR
   */
  @PatchMapping("/compareticketimports/{id}")
  public XfR patchUpdate(@RequestBody CompareTicketImport compareTicketImport,@PathVariable Long id) {
      CompareTicketImport upcompareTicketImport = compareTicketImportServiceImpl.getById(id);
      if(upcompareTicketImport != null){
        upcompareTicketImport = ObjectCopyUtils.copyProperties(compareTicketImport,upcompareTicketImport,true);
      }
      return XfR.ok(compareTicketImportServiceImpl.updateById(upcompareTicketImport));
  }

  /**
   * 通过id删除比对进口发票
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/compareticketimports/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(compareTicketImportServiceImpl.removeById(id));
  }

  @PostMapping("/compareticketimports/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "compare_ticket_import");
     params.put("request", condition);

     return XfR.ok(compareTicketImportServiceImpl.querys(params));
  }

}
