package com.xforceplus.ultraman.app.imageservicesaas.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.imageservicesaas.entity.ConfigDataMappingItem;
import com.xforceplus.ultraman.app.imageservicesaas.service.IConfigDataMappingItemService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2025-10-27
 */
@RestController
public class ConfigDataMappingItemController {

  @Autowired
  private IConfigDataMappingItemService configDataMappingItemServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param configDataMappingItem ${table.comment}
   * @return
   */
  @GetMapping("/configdatamappingitems" )
  public XfR getConfigDataMappingItems(XfPage page, ConfigDataMappingItem configDataMappingItem) {
    return XfR.ok(configDataMappingItemServiceImpl.page(page, Wrappers.query(configDataMappingItem)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/configdatamappingitems/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(configDataMappingItemServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param configDataMappingItem ${table.comment}
   * @return XfR
   */
  @PostMapping("/configdatamappingitems")
  public XfR save(@RequestBody ConfigDataMappingItem configDataMappingItem) {
     return XfR.ok(configDataMappingItemServiceImpl.save(configDataMappingItem));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param configDataMappingItem ${table.comment}
   * @return XfR
   */
  @PutMapping("/configdatamappingitems/{id}")
  public XfR putUpdate(@RequestBody ConfigDataMappingItem configDataMappingItem,@PathVariable Long id) {
      configDataMappingItem.setId(id);
      return XfR.ok(configDataMappingItemServiceImpl.updateById(configDataMappingItem));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param configDataMappingItem ${table.comment}
   * @return XfR
   */
  @PatchMapping("/configdatamappingitems/{id}")
  public XfR patchUpdate(@RequestBody ConfigDataMappingItem configDataMappingItem,@PathVariable Long id) {
      ConfigDataMappingItem upconfigDataMappingItem = configDataMappingItemServiceImpl.getById(id);
      if(upconfigDataMappingItem != null){
        upconfigDataMappingItem = ObjectCopyUtils.copyProperties(configDataMappingItem,upconfigDataMappingItem,true);
      }
      return XfR.ok(configDataMappingItemServiceImpl.updateById(upconfigDataMappingItem));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/configdatamappingitems/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(configDataMappingItemServiceImpl.removeById(id));
  }

  @PostMapping("/configdatamappingitems/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "config_data_mapping_item");
     params.put("request", condition);

     return XfR.ok(configDataMappingItemServiceImpl.querys(params));
  }

}
